/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.codec.support;

import io.netty.buffer.ByteBuf;
import org.joyqueue.network.command.JoyQueuePayloadCodecRegistry;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.Decoder;
import org.joyqueue.network.transport.codec.DefaultDecoder;
import org.joyqueue.network.transport.codec.DefaultEncoder;
import org.joyqueue.network.transport.codec.Encoder;
import org.joyqueue.network.transport.codec.JoyQueueHeaderCodec;
import org.joyqueue.network.transport.codec.PayloadCodecFactory;
import org.joyqueue.network.transport.exception.TransportException;

public class JoyQueueCodec
implements Codec {
    private Codec headerCodec;
    private PayloadCodecFactory payloadCodecFactory;
    private Decoder decoder;
    private Encoder encoder;

    public JoyQueueCodec() {
        PayloadCodecFactory payloadCodecFactory = new PayloadCodecFactory();
        JoyQueuePayloadCodecRegistry.register(payloadCodecFactory);
        this.headerCodec = new JoyQueueHeaderCodec();
        this.payloadCodecFactory = payloadCodecFactory;
        this.decoder = new DefaultDecoder(this.headerCodec, payloadCodecFactory);
        this.encoder = new DefaultEncoder(this.headerCodec, payloadCodecFactory);
    }

    public JoyQueueCodec(PayloadCodecFactory payloadCodecFactory) {
        this(new JoyQueueHeaderCodec(), payloadCodecFactory);
    }

    public JoyQueueCodec(Codec headerCodec, PayloadCodecFactory payloadCodecFactory) {
        this.headerCodec = headerCodec;
        this.payloadCodecFactory = payloadCodecFactory;
        this.decoder = new DefaultDecoder(headerCodec, payloadCodecFactory);
        this.encoder = new DefaultEncoder(headerCodec, payloadCodecFactory);
    }

    @Override
    public Object decode(ByteBuf buffer) throws TransportException.CodecException {
        return this.decoder.decode(buffer);
    }

    @Override
    public void encode(Object obj, ByteBuf buffer) throws TransportException.CodecException {
        this.encoder.encode(obj, buffer);
    }

    public PayloadCodecFactory getPayloadCodecFactory() {
        return this.payloadCodecFactory;
    }
}

