/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.command;

import java.util.concurrent.atomic.AtomicBoolean;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Releasable;

public class Command {
    protected Header header;
    protected Object payload;
    protected AtomicBoolean released = new AtomicBoolean(false);
    protected Object attachment;

    public Command() {
    }

    public Command(Object payload) {
        this.payload = payload;
    }

    public Command(Header header, Object payload) {
        this.header = header;
        this.payload = payload;
    }

    public Command(Header header, Object payload, Object attachment) {
        this.header = header;
        this.payload = payload;
        this.attachment = attachment;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public boolean isSuccess() {
        return this.header.getStatus() == JoyQueueCode.SUCCESS.getCode();
    }

    public void release() {
        if (this.payload == null || !(this.payload instanceof Releasable)) {
            return;
        }
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        ((Releasable)this.payload).release();
    }

    public String toString() {
        return String.format("Command:{header:{type:%s, version: %s}, payload: %s}", null != this.header ? Integer.valueOf(this.header.getType()) : null, null != this.header ? Integer.valueOf(this.header.getVersion()) : null, this.payload);
    }

    public static class Builder {
        protected Command command = new Command();

        public Builder() {
        }

        public Builder(Command command) {
            this.command = command;
        }

        public static Builder build() {
            return new Builder();
        }

        public static Builder build(Command command) {
            return new Builder(command);
        }

        public Builder header(Header header) {
            this.command.setHeader(header);
            return this;
        }

        public Builder payload(Object payload) {
            this.command.setPayload(payload);
            return this;
        }
    }
}

