/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.command.support;

import io.netty.channel.Channel;
import org.joyqueue.network.transport.ChannelTransport;
import org.joyqueue.network.transport.RequestBarrier;
import org.joyqueue.network.transport.TransportHelper;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandDispatcher;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.support.RequestHandler;
import org.joyqueue.network.transport.command.support.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandDispatcher
implements CommandDispatcher {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultCommandDispatcher.class);
    private RequestBarrier requestBarrier;
    private RequestHandler requestHandler;
    private ResponseHandler responseHandler;

    public DefaultCommandDispatcher(RequestBarrier requestBarrier, RequestHandler requestHandler, ResponseHandler responseHandler) {
        this.requestBarrier = requestBarrier;
        this.requestHandler = requestHandler;
        this.responseHandler = responseHandler;
    }

    @Override
    public void dispatch(Channel channel, Command command) {
        ChannelTransport transport = TransportHelper.getOrNewTransport(channel, this.requestBarrier);
        Direction direction = command.getHeader().getDirection();
        if (direction.equals((Object)Direction.REQUEST)) {
            this.requestHandler.handle(transport, command);
        } else if (direction.equals((Object)Direction.RESPONSE)) {
            this.responseHandler.handle(transport, command);
        } else {
            logger.error("unsupported direction, direction: {}, transport: {}, command: {}", new Object[]{direction, transport, command});
        }
    }

    public RequestBarrier getRequestBarrier() {
        return this.requestBarrier;
    }
}

