/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.command.support;

import org.joyqueue.network.protocol.ExceptionHandlerProvider;
import org.joyqueue.network.protocol.Protocol;
import org.joyqueue.network.transport.RequestBarrier;
import org.joyqueue.network.transport.command.CommandDispatcher;
import org.joyqueue.network.transport.command.CommandDispatcherFactory;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.command.handler.filter.CommandHandlerFilterFactory;
import org.joyqueue.network.transport.command.support.DefaultCommandDispatcher;
import org.joyqueue.network.transport.command.support.RequestHandler;
import org.joyqueue.network.transport.command.support.ResponseHandler;
import org.joyqueue.network.transport.config.TransportConfig;

public class DefaultCommandDispatcherFactory
implements CommandDispatcherFactory {
    private TransportConfig transportConfig;
    private RequestBarrier requestBarrier;
    private CommandHandlerFilterFactory commandHandlerFilterFactory;
    private ExceptionHandler exceptionHandler;

    public DefaultCommandDispatcherFactory(TransportConfig transportConfig, RequestBarrier requestBarrier, CommandHandlerFilterFactory commandHandlerFilterFactory, ExceptionHandler exceptionHandler) {
        this.transportConfig = transportConfig;
        this.requestBarrier = requestBarrier;
        this.commandHandlerFilterFactory = commandHandlerFilterFactory;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public CommandDispatcher getCommandDispatcher(Protocol protocol) {
        ExceptionHandler exceptionHandler = this.getExceptionHandler(protocol);
        CommandHandlerFactory commandHandlerFactory = protocol.createCommandHandlerFactory();
        RequestHandler requestHandler = new RequestHandler(commandHandlerFactory, this.commandHandlerFilterFactory, exceptionHandler);
        ResponseHandler responseHandler = new ResponseHandler(this.transportConfig, this.requestBarrier, exceptionHandler);
        return new DefaultCommandDispatcher(this.requestBarrier, requestHandler, responseHandler);
    }

    protected ExceptionHandler getExceptionHandler(Protocol protocol) {
        ExceptionHandler customExceptionHandler;
        if (protocol instanceof ExceptionHandlerProvider && (customExceptionHandler = ((ExceptionHandlerProvider)((Object)protocol)).getExceptionHandler()) != null) {
            return customExceptionHandler;
        }
        return this.exceptionHandler;
    }
}

