/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.command.support;

import com.google.common.collect.Maps;
import java.util.Map;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.Types;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandHandlerFactory
implements CommandHandlerFactory {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultCommandHandlerFactory.class);
    private Map<Integer, CommandHandler> commandHandlerMapper = Maps.newHashMap();

    @Override
    public CommandHandler getHandler(Command command) {
        int commandType = command.getHeader().getType();
        return this.commandHandlerMapper.get(commandType);
    }

    public void register(CommandHandler commandHandler) {
        if (commandHandler instanceof Types) {
            Types types = (Types)((Object)commandHandler);
            for (int type : types.types()) {
                this.register(type, commandHandler);
            }
        } else if (commandHandler instanceof Type) {
            this.register(((Type)((Object)commandHandler)).type(), commandHandler);
        } else {
            logger.warn("unsupported command type, commandHandler: {}", (Object)commandHandler);
        }
    }

    public void register(int type, CommandHandler commandHandler) {
        this.commandHandlerMapper.put(type, commandHandler);
    }
}

