/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.session.session;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicLong;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.config.ClientConfig;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.network.transport.session.session.config.TransportSessionConfig;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportSession
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(TransportSession.class);
    private int id;
    private String host;
    private int port;
    private SocketAddress address;
    private ClientConfig clientConfig;
    private TransportSessionConfig config;
    private TransportClient transportClient;
    private volatile Transport transport;
    private volatile AtomicLong lastReconnect = new AtomicLong();

    public TransportSession(int id, String host, int port, ClientConfig clientConfig, TransportSessionConfig config, TransportClient transportClient) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.address = new InetSocketAddress(host, port);
        this.clientConfig = clientConfig;
        this.config = config;
        this.transportClient = transportClient;
        this.transport = this.initTransport();
    }

    protected Transport initTransport() {
        try {
            return this.transportClient.createTransport(this.address);
        }
        catch (Exception e) {
            logger.error("create transport session exception, address: {}", (Object)this.address, (Object)e);
            return null;
        }
    }

    protected void doStop() {
        this.transport.stop();
    }

    public void async(Command request, int timeout, CommandCallback callback) {
        if (!this.checkTransport()) {
            callback.onException(request, new TransportException.ConnectionException(this.address.toString()));
            return;
        }
        this.transport.async(request, timeout, callback);
    }

    public Command sync(Command request, int timeout) {
        if (!this.checkTransport()) {
            throw new TransportException.ConnectionException(this.address.toString());
        }
        return this.transport.sync(request, timeout);
    }

    protected boolean checkTransport() {
        if (this.transport != null) {
            return true;
        }
        long lastReconnect = this.lastReconnect.get();
        if (SystemClock.now() - lastReconnect < (long)this.config.getReconnectInterval()) {
            return false;
        }
        if (!this.lastReconnect.compareAndSet(lastReconnect, SystemClock.now())) {
            return false;
        }
        this.transport = this.initTransport();
        return this.transport != null;
    }

    public int getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

