/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.session.session;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.joyqueue.domain.Broker;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.TransportClientFactory;
import org.joyqueue.network.transport.config.ClientConfig;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.network.transport.session.session.TransportSession;
import org.joyqueue.network.transport.session.session.config.TransportSessionConfig;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportSessionManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(TransportSessionManager.class);
    private TransportSessionConfig config;
    private TransportClientFactory transportClientFactory;
    private ClientConfig clientConfig;
    private TransportClient client;
    private Cache<Integer, TransportSession> sessions;

    public TransportSessionManager(TransportSessionConfig config, ClientConfig clientConfig, TransportClientFactory transportClientFactory) {
        this.config = config;
        this.clientConfig = clientConfig;
        this.transportClientFactory = transportClientFactory;
    }

    protected void validate() throws Exception {
        this.client = this.transportClientFactory.create(this.clientConfig);
        this.sessions = CacheBuilder.newBuilder().expireAfterAccess((long)this.config.getSessionExpireTime(), TimeUnit.MILLISECONDS).removalListener(notification -> {
            try {
                TransportSession session = (TransportSession)((Object)((Object)notification.getValue()));
                logger.info("create session, id: {}, ip: {}, port: {}", new Object[]{session.getId(), session.getHost(), session.getPort()});
                session.stop();
            }
            catch (Exception e) {
                logger.error("stop session exception, id: {}", notification.getKey(), (Object)e);
            }
        }).build();
    }

    public void doStop() {
        if (this.client != null) {
            this.client.stop();
        }
        if (this.sessions != null) {
            this.sessions.cleanUp();
        }
    }

    public TransportSession getSession(Broker broker) {
        return this.getSession(broker.getId());
    }

    public TransportSession getSession(int brokerId) {
        return (TransportSession)((Object)this.sessions.getIfPresent((Object)brokerId));
    }

    public TransportSession getOrCreateSession(Broker broker) {
        return this.getOrCreateSession(broker.getId(), broker.getIp(), broker.getBackEndPort());
    }

    public TransportSession getOrCreateSession(int brokerId, String brokerHost, int brokerPort) {
        try {
            return (TransportSession)((Object)this.sessions.get((Object)brokerId, () -> {
                logger.info("create session, id: {}, ip: {}, port: {}", new Object[]{brokerId, brokerHost, brokerPort});
                return new TransportSession(brokerId, brokerHost, brokerPort, this.clientConfig, this.config, this.client);
            }));
        }
        catch (ExecutionException e) {
            throw new TransportException.ConnectionException(String.format("create session failed, broker: {id: %s, ip: %s, port: %s}", brokerId, brokerHost, brokerPort), e);
        }
    }
}

