/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.support;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.event.TransportEventHandler;
import org.joyqueue.network.handler.ExceptionChannelHandler;
import org.joyqueue.network.transport.RequestBarrier;
import org.joyqueue.network.transport.TransportServerSupport;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.support.NettyDecoder;
import org.joyqueue.network.transport.codec.support.NettyEncoder;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.command.support.DefaultCommandDispatcher;
import org.joyqueue.network.transport.command.support.RequestHandler;
import org.joyqueue.network.transport.command.support.ResponseHandler;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.network.transport.handler.CommandInvocation;
import org.joyqueue.toolkit.concurrent.EventBus;

public class DefaultTransportServer
extends TransportServerSupport {
    private Codec codec;
    private ExceptionHandler exceptionHandler;
    private RequestBarrier requestBarrier;
    private RequestHandler requestHandler;
    private ResponseHandler responseHandler;
    private EventBus<TransportEvent> transportEventBus;

    public DefaultTransportServer(ServerConfig serverConfig, String host, int port, Codec codec, ExceptionHandler exceptionHandler, RequestBarrier requestBarrier, RequestHandler requestHandler, ResponseHandler responseHandler, EventBus<TransportEvent> transportEventBus) {
        super(serverConfig, host, port);
        this.codec = codec;
        this.exceptionHandler = exceptionHandler;
        this.requestBarrier = requestBarrier;
        this.requestHandler = requestHandler;
        this.responseHandler = responseHandler;
        this.transportEventBus = transportEventBus;
    }

    @Override
    protected ChannelHandler newChannelHandlerPipeline() {
        final DefaultCommandDispatcher commandDispatcher = new DefaultCommandDispatcher(this.requestBarrier, this.requestHandler, this.responseHandler);
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{new NettyDecoder(DefaultTransportServer.this.codec)}).addLast(new ChannelHandler[]{new NettyEncoder(DefaultTransportServer.this.codec)}).addLast(new ChannelHandler[]{new TransportEventHandler(DefaultTransportServer.this.requestBarrier, (EventBus<TransportEvent>)DefaultTransportServer.this.transportEventBus)}).addLast(new ChannelHandler[]{new ExceptionChannelHandler(DefaultTransportServer.this.exceptionHandler, DefaultTransportServer.this.requestBarrier)}).addLast(new ChannelHandler[]{new CommandInvocation(commandDispatcher)});
            }
        };
    }

    @Override
    protected void doStop() {
        this.requestBarrier.clear();
        if (this.transportEventBus != null) {
            this.transportEventBus.stop();
        }
        super.doStop();
    }
}

