/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.support;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.transport.ChannelTransport;
import org.joyqueue.network.transport.TransportAttribute;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.TransportState;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.config.TransportConfig;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.network.transport.support.FailoverChannelTransport;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverGroupChannelTransport
implements ChannelTransport {
    protected static final Logger logger = LoggerFactory.getLogger(FailoverGroupChannelTransport.class);
    private List<SocketAddress> addresses;
    private long connectionTimeout;
    private TransportClient transportClient;
    private TransportConfig config;
    private EventBus<TransportEvent> transportEventBus;
    private volatile int roundrobinIndex = 0;
    private ConcurrentMap<SocketAddress, ChannelTransportEntry> transports = new ConcurrentHashMap<SocketAddress, ChannelTransportEntry>();

    public FailoverGroupChannelTransport(List<SocketAddress> addresses, long connectionTimeout, TransportClient transportClient, TransportConfig config, EventBus<TransportEvent> transportEventBus) {
        this.addresses = addresses;
        this.connectionTimeout = connectionTimeout;
        this.transportClient = transportClient;
        this.config = config;
        this.transportEventBus = transportEventBus;
        this.init();
    }

    @Override
    public Command sync(Command command) throws TransportException {
        return this.sync(command, 0L);
    }

    @Override
    public void async(Command command, CommandCallback callback) throws TransportException {
        this.async(command, 0L, callback);
    }

    @Override
    public CompletableFuture<?> async(Command command) throws TransportException {
        return this.async(command, 0L);
    }

    @Override
    public void oneway(Command command) throws TransportException {
        this.oneway(command, 0L);
    }

    @Override
    public void acknowledge(Command request, Command response) throws TransportException {
        this.acknowledge(request, response, null);
    }

    @Override
    public Command sync(Command command, long timeout) throws TransportException {
        return this.execute(transport -> transport.sync(command, timeout));
    }

    @Override
    public void async(Command command, long timeout, CommandCallback callback) throws TransportException {
        this.execute(transport -> {
            transport.async(command, timeout, callback);
            return null;
        });
    }

    @Override
    public CompletableFuture<?> async(Command command, long timeout) throws TransportException {
        return this.execute(transport -> transport.async(command, timeout));
    }

    @Override
    public void oneway(Command command, long timeout) throws TransportException {
        this.execute(transport -> {
            transport.oneway(command, timeout);
            return null;
        });
    }

    @Override
    public void acknowledge(Command request, Command response, CommandCallback callback) throws TransportException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.execute(transport -> transport.remoteAddress());
    }

    @Override
    public TransportAttribute attr() {
        return this.execute(transport -> transport.attr());
    }

    @Override
    public void attr(TransportAttribute attribute) {
        this.execute(transport -> {
            transport.attr(attribute);
            return null;
        });
    }

    @Override
    public TransportState state() {
        for (Map.Entry entry : this.transports.entrySet()) {
            ChannelTransport transport = ((ChannelTransportEntry)entry.getValue()).getTransport();
            if (transport == null || !transport.state().equals((Object)TransportState.CONNECTED)) continue;
            return TransportState.CONNECTED;
        }
        return TransportState.DISCONNECTED;
    }

    @Override
    public void stop() {
        for (Map.Entry entry : this.transports.entrySet()) {
            ChannelTransport transport = ((ChannelTransportEntry)entry.getValue()).getTransport();
            if (transport == null) continue;
            transport.stop();
        }
    }

    @Override
    public Channel getChannel() {
        return this.execute(transport -> transport.getChannel());
    }

    protected void init() {
        for (SocketAddress address : this.addresses) {
            try {
                this.getOrCreateTransport(address);
                return;
            }
            catch (TransportException e) {
                logger.warn("create transport exception, address: {}", (Object)address, (Object)e);
                ++this.roundrobinIndex;
            }
        }
        throw new TransportException.ConnectionException();
    }

    protected <T> T execute(Function<ChannelTransport, T> function) throws TransportException {
        int addressesSize = this.addresses.size();
        int index = this.roundrobinIndex;
        for (int i = 0; i < addressesSize; ++i) {
            if (index >= addressesSize) {
                index = 0;
            }
            SocketAddress address = this.addresses.get(index);
            try {
                ChannelTransport transport = this.getOrCreateTransport(address);
                T result = function.apply(transport);
                this.roundrobinIndex = index;
                return result;
            }
            catch (TransportException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("execute exception, address: {}", (Object)address, (Object)e);
                }
                ++index;
                continue;
            }
        }
        throw new TransportException.RequestErrorException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ChannelTransport getOrCreateTransport(SocketAddress address) throws TransportException {
        ChannelTransportEntry transportEntry = (ChannelTransportEntry)this.transports.get(address);
        long now = SystemClock.now();
        if (transportEntry != null) {
            if (transportEntry.getTransport() != null) {
                return transportEntry.getTransport();
            }
            if (now - transportEntry.getLastConnect() < (long)this.config.getRetryDelay()) {
                throw new TransportException.ConnectionException(address.toString());
            }
        }
        ConcurrentMap<SocketAddress, ChannelTransportEntry> concurrentMap = this.transports;
        synchronized (concurrentMap) {
            transportEntry = (ChannelTransportEntry)this.transports.get(address);
            if (transportEntry != null) {
                if (transportEntry.getTransport() != null) {
                    return transportEntry.getTransport();
                }
                if (now - transportEntry.getLastConnect() < (long)this.config.getRetryDelay()) {
                    throw new TransportException.ConnectionException(address.toString());
                }
            } else {
                transportEntry = new ChannelTransportEntry();
            }
            ChannelTransport transport = null;
            try {
                transport = this.createTransport(address);
                transportEntry.setTransport(transport);
                if (logger.isDebugEnabled()) {
                    logger.debug("create transport, address: {}", (Object)address);
                }
                ChannelTransport channelTransport = transport;
                return channelTransport;
            }
            catch (TransportException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("create transport exception, address: {}", (Object)address, (Object)e);
                }
                throw e;
            }
            finally {
                transportEntry.setLastConnect(now);
                this.transports.put(address, transportEntry);
            }
        }
    }

    protected ChannelTransport createTransport(SocketAddress address) throws TransportException {
        ChannelTransport transport = (ChannelTransport)this.transportClient.createTransport(address, this.connectionTimeout);
        return new FailoverChannelTransport(transport, address, this.connectionTimeout, this.transportClient, this.config, this.transportEventBus);
    }

    class ChannelTransportEntry {
        private ChannelTransport transport;
        private volatile long lastConnect;

        ChannelTransportEntry() {
        }

        ChannelTransportEntry(long lastConnect) {
            this.lastConnect = lastConnect;
        }

        ChannelTransportEntry(ChannelTransport transport, long lastConnect) {
            this.transport = transport;
            this.lastConnect = lastConnect;
        }

        public ChannelTransport getTransport() {
            return this.transport;
        }

        public void setTransport(ChannelTransport transport) {
            this.transport = transport;
        }

        public long getLastConnect() {
            return this.lastConnect;
        }

        public void setLastConnect(long lastConnect) {
            this.lastConnect = lastConnect;
        }
    }
}

