/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.support;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.transport.ChannelTransport;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.TransportClientSupport;
import org.joyqueue.network.transport.config.TransportConfig;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.network.transport.support.FailoverChannelTransport;
import org.joyqueue.network.transport.support.FailoverGroupChannelTransport;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;

public class FailoverTransportClient
implements TransportClient {
    private static final String GROUP_SPLITTER = ",";
    private TransportClient delegate;
    private TransportConfig config;
    private EventBus<TransportEvent> transportEventBus;

    public FailoverTransportClient(TransportClient delegate, TransportConfig config, EventBus<TransportEvent> transportEventBus) {
        this.delegate = delegate;
        this.config = config;
        this.transportEventBus = transportEventBus;
    }

    @Override
    public Transport createTransport(String address) throws TransportException {
        return this.createTransport(address, -1L);
    }

    @Override
    public Transport createTransport(String address, long connectionTimeout) throws TransportException {
        String[] addresses = StringUtils.splitByWholeSeparator((String)address, (String)GROUP_SPLITTER);
        if (addresses.length == 1) {
            return this.createTransport(TransportClientSupport.createInetSocketAddress(address), connectionTimeout);
        }
        ArrayList<SocketAddress> socketAddresses = new ArrayList<SocketAddress>(addresses.length);
        for (String addressItem : addresses) {
            InetSocketAddress socketAddress = TransportClientSupport.createInetSocketAddress(addressItem);
            socketAddresses.add(socketAddress);
        }
        return this.createGroupTransport(socketAddresses, connectionTimeout);
    }

    @Override
    public Transport createTransport(SocketAddress address) throws TransportException {
        return this.createTransport(address, -1L);
    }

    @Override
    public Transport createTransport(SocketAddress address, long connectionTimeout) throws TransportException {
        ChannelTransport transport = (ChannelTransport)this.delegate.createTransport(address, connectionTimeout);
        return new FailoverChannelTransport(transport, address, connectionTimeout, this.delegate, this.config, this.transportEventBus);
    }

    protected Transport createGroupTransport(List<SocketAddress> addresses, long connectionTimeout) throws TransportException {
        return new FailoverGroupChannelTransport(addresses, connectionTimeout, this.delegate, this.config, this.transportEventBus);
    }

    @Override
    public void addListener(EventListener<TransportEvent> listener) {
        this.delegate.addListener(listener);
    }

    @Override
    public void removeListener(EventListener<TransportEvent> listener) {
        this.delegate.removeListener(listener);
    }

    public void start() throws Exception {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public boolean isStarted() {
        return this.delegate.isStarted();
    }
}

