/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.sql.h2;

import io.journalkeeper.sql.state.jdbc.DataSourceFactory;
import java.nio.file.Path;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.h2.jdbcx.JdbcDataSource;

public class H2DataSourceFactory
implements DataSourceFactory {
    public DataSource createDataSource(Path path, Properties properties) {
        String url = properties.getProperty("sql.datasource.url");
        if (StringUtils.isBlank((CharSequence)url)) {
            url = String.format("jdbc:h2:file:%s/data;AUTO_SERVER=TRUE;MVCC=TRUE;LOCK_TIMEOUT=30000", path.toString());
        }
        JdbcDataSource datasource = new JdbcDataSource();
        datasource.setURL(url);
        return datasource;
    }

    public String type() {
        return "h2";
    }
}

