/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc;

import io.journalkeeper.rpc.RpcAccessPointFactory;
import io.journalkeeper.rpc.RpcException;
import io.journalkeeper.rpc.UriSupport;
import io.journalkeeper.rpc.client.ClientServerRpcAccessPoint;
import io.journalkeeper.rpc.client.JournalKeeperClientServerRpcAccessPoint;
import io.journalkeeper.rpc.codec.JournalKeeperCodec;
import io.journalkeeper.rpc.handler.ServerRpcCommandHandlerRegistry;
import io.journalkeeper.rpc.remoting.transport.TransportClientFactory;
import io.journalkeeper.rpc.remoting.transport.TransportServer;
import io.journalkeeper.rpc.remoting.transport.command.support.UriRoutedCommandHandlerFactory;
import io.journalkeeper.rpc.remoting.transport.config.ClientConfig;
import io.journalkeeper.rpc.remoting.transport.config.ServerConfig;
import io.journalkeeper.rpc.remoting.transport.support.DefaultTransportClientFactory;
import io.journalkeeper.rpc.remoting.transport.support.DefaultTransportServerFactory;
import io.journalkeeper.rpc.server.JournalKeeperServerRpcAccessPoint;
import io.journalkeeper.rpc.server.ServerRpc;
import io.journalkeeper.rpc.server.ServerRpcAccessPoint;
import io.journalkeeper.utils.spi.Singleton;
import io.journalkeeper.utils.state.ServerStateMachine;
import io.journalkeeper.utils.state.StateServer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public class JournalKeeperRpcAccessPointFactory
implements RpcAccessPointFactory {
    private final TransportClientFactory transportClientFactory;
    private final Map<InetSocketAddress, TransportServerAndReferenceCount> transportServerMap = new HashMap<InetSocketAddress, TransportServerAndReferenceCount>();
    private final DefaultTransportServerFactory defaultTransportServerFactory;
    private final UriRoutedCommandHandlerFactory handlerFactory;

    public JournalKeeperRpcAccessPointFactory() {
        JournalKeeperCodec journalKeeperCodec = new JournalKeeperCodec();
        this.transportClientFactory = new DefaultTransportClientFactory(journalKeeperCodec);
        this.handlerFactory = new UriRoutedCommandHandlerFactory();
        this.defaultTransportServerFactory = new DefaultTransportServerFactory(new JournalKeeperCodec(), this.handlerFactory);
    }

    public ServerRpcAccessPoint createServerRpcAccessPoint(Properties properties) {
        ClientConfig clientConfig = this.toClientConfig(properties);
        return new JournalKeeperServerRpcAccessPoint(this.transportClientFactory.create(clientConfig), properties);
    }

    public ClientServerRpcAccessPoint createClientServerRpcAccessPoint(Properties properties) {
        ClientConfig clientConfig = this.toClientConfig(properties);
        return new JournalKeeperClientServerRpcAccessPoint(this.transportClientFactory.create(clientConfig), properties);
    }

    public synchronized StateServer bindServerService(final ServerRpc serverRpc) {
        final InetSocketAddress address = UriSupport.parseUri((URI)serverRpc.serverUri());
        final TransportServerAndReferenceCount server = this.transportServerMap.computeIfAbsent(address, addr -> {
            try {
                TransportServer ts = this.defaultTransportServerFactory.bind(new ServerConfig(), addr.getHostName(), addr.getPort());
                ts.start();
                return new TransportServerAndReferenceCount(ts);
            }
            catch (Throwable t) {
                throw new RpcException(t);
            }
        });
        server.getReferenceCounter().incrementAndGet();
        ServerRpcCommandHandlerRegistry.register(this.handlerFactory, serverRpc);
        return new ServerStateMachine(true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doStop() {
                super.doStop();
                int ref = server.getReferenceCounter().decrementAndGet();
                JournalKeeperRpcAccessPointFactory.this.handlerFactory.unRegister(serverRpc.serverUri());
                if (ref <= 0) {
                    JournalKeeperRpcAccessPointFactory journalKeeperRpcAccessPointFactory = JournalKeeperRpcAccessPointFactory.this;
                    synchronized (journalKeeperRpcAccessPointFactory) {
                        JournalKeeperRpcAccessPointFactory.this.transportServerMap.remove(address);
                        server.getTransportServer().stop();
                    }
                }
            }
        };
    }

    private ClientConfig toClientConfig(Properties properties) {
        return new ClientConfig();
    }

    private static class TransportServerAndReferenceCount {
        private final TransportServer transportServer;
        private final AtomicInteger referenceCounter = new AtomicInteger(0);

        public TransportServerAndReferenceCount(TransportServer transportServer) {
            this.transportServer = transportServer;
        }

        public TransportServer getTransportServer() {
            return this.transportServer;
        }

        public AtomicInteger getReferenceCounter() {
            return this.referenceCounter;
        }
    }
}

