/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.client;

import io.journalkeeper.exceptions.RequestTimeoutException;
import io.journalkeeper.exceptions.TransportException;
import io.journalkeeper.rpc.BaseResponse;
import io.journalkeeper.rpc.RpcException;
import io.journalkeeper.rpc.client.AddPullWatchResponse;
import io.journalkeeper.rpc.client.CheckLeadershipResponse;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.CompleteTransactionRequest;
import io.journalkeeper.rpc.client.CompleteTransactionResponse;
import io.journalkeeper.rpc.client.ConvertRollRequest;
import io.journalkeeper.rpc.client.ConvertRollResponse;
import io.journalkeeper.rpc.client.CreateTransactionRequest;
import io.journalkeeper.rpc.client.CreateTransactionResponse;
import io.journalkeeper.rpc.client.GetOpeningTransactionsResponse;
import io.journalkeeper.rpc.client.GetServerStatusResponse;
import io.journalkeeper.rpc.client.GetServersResponse;
import io.journalkeeper.rpc.client.GetSnapshotsResponse;
import io.journalkeeper.rpc.client.LastAppliedResponse;
import io.journalkeeper.rpc.client.PullEventsRequest;
import io.journalkeeper.rpc.client.PullEventsResponse;
import io.journalkeeper.rpc.client.QueryStateRequest;
import io.journalkeeper.rpc.client.QueryStateResponse;
import io.journalkeeper.rpc.client.RemovePullWatchRequest;
import io.journalkeeper.rpc.client.RemovePullWatchResponse;
import io.journalkeeper.rpc.client.UpdateClusterStateRequest;
import io.journalkeeper.rpc.client.UpdateClusterStateResponse;
import io.journalkeeper.rpc.client.UpdateVotersRequest;
import io.journalkeeper.rpc.client.UpdateVotersResponse;
import io.journalkeeper.rpc.remoting.transport.Transport;
import io.journalkeeper.rpc.remoting.transport.TransportClient;
import io.journalkeeper.rpc.remoting.transport.TransportState;
import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import io.journalkeeper.rpc.utils.CommandSupport;
import io.journalkeeper.utils.event.Event;
import io.journalkeeper.utils.event.EventBus;
import io.journalkeeper.utils.event.EventWatcher;
import io.journalkeeper.utils.threads.AsyncLoopThread;
import io.journalkeeper.utils.threads.ThreadBuilder;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServerRpcStub
implements ClientServerRpc {
    private static final Logger logger = LoggerFactory.getLogger(ClientServerRpcStub.class);
    protected final TransportClient transportClient;
    protected final InetSocketAddress inetSocketAddress;
    protected final URI uri;
    protected Transport transport;
    protected EventBus eventBus = null;
    protected AsyncLoopThread pullEventThread = null;
    protected long pullWatchId = -1L;
    protected long ackSequence = -1L;
    protected AtomicBoolean lastRequestSuccess = new AtomicBoolean(true);
    protected final int version;

    public ClientServerRpcStub(TransportClient transportClient, URI uri, InetSocketAddress inetSocketAddress, int version) {
        this.transportClient = transportClient;
        this.uri = uri;
        this.version = version;
        this.inetSocketAddress = inetSocketAddress;
        logger.info("Using protocol version {}, supported versions up to {}.", (Object)version, (Object)2);
    }

    public URI serverUri() {
        return this.uri;
    }

    protected <Q, R extends BaseResponse> CompletableFuture<R> sendRequest(Q request, int rpcType) {
        try {
            if (!this.isAlive()) {
                this.closeTransport();
                this.transport = this.createTransport();
            }
            CompletableFuture future = CommandSupport.sendRequest(request, rpcType, this.transport, this.uri, this.version);
            future.whenCompleteAsync((response, exception) -> {
                if (null != exception) {
                    this.stop();
                    this.lastRequestSuccess.set(false);
                } else {
                    this.lastRequestSuccess.set(true);
                }
            });
            return future.exceptionally(e -> {
                try {
                    throw e;
                }
                catch (TransportException.RequestTimeoutException te) {
                    throw new RequestTimeoutException((Throwable)te);
                }
                catch (io.journalkeeper.rpc.remoting.transport.exception.TransportException e1) {
                    throw new TransportException((Throwable)e1);
                }
                catch (Throwable t) {
                    throw new CompletionException(t);
                }
            });
        }
        catch (Throwable t) {
            CompletableFuture completableFuture = new CompletableFuture();
            completableFuture.completeExceptionally((Throwable)new TransportException(t));
            return completableFuture;
        }
    }

    public CompletableFuture<UpdateClusterStateResponse> updateClusterState(UpdateClusterStateRequest request) {
        return this.sendRequest(request, 1);
    }

    public CompletableFuture<QueryStateResponse> queryClusterState(QueryStateRequest request) {
        return this.sendRequest(request, 2);
    }

    public CompletableFuture<QueryStateResponse> queryServerState(QueryStateRequest request) {
        return this.sendRequest(request, 3);
    }

    public CompletableFuture<LastAppliedResponse> lastApplied() {
        return this.sendRequest(null, 4);
    }

    public CompletableFuture<QueryStateResponse> querySnapshot(QueryStateRequest request) {
        return this.sendRequest(request, 5);
    }

    public CompletableFuture<GetServersResponse> getServers() {
        return this.sendRequest(null, 6);
    }

    public CompletableFuture<GetServerStatusResponse> getServerStatus() {
        return this.sendRequest(null, 13);
    }

    public CompletableFuture<AddPullWatchResponse> addPullWatch() {
        return this.sendRequest(null, 9);
    }

    public CompletableFuture<RemovePullWatchResponse> removePullWatch(RemovePullWatchRequest request) {
        return this.sendRequest(request, 10);
    }

    public CompletableFuture<UpdateVotersResponse> updateVoters(UpdateVotersRequest request) {
        return this.sendRequest(request, 7);
    }

    public CompletableFuture<PullEventsResponse> pullEvents(PullEventsRequest request) {
        return this.sendRequest(request, 11);
    }

    public CompletableFuture<ConvertRollResponse> convertRoll(ConvertRollRequest request) {
        return this.sendRequest(request, 12);
    }

    public CompletableFuture<CreateTransactionResponse> createTransaction(CreateTransactionRequest request) {
        return this.sendRequest(request, 14);
    }

    public CompletableFuture<CompleteTransactionResponse> completeTransaction(CompleteTransactionRequest request) {
        return this.sendRequest(request, 15);
    }

    public CompletableFuture<GetOpeningTransactionsResponse> getOpeningTransactions() {
        return this.sendRequest(null, 16);
    }

    public CompletableFuture<GetSnapshotsResponse> getSnapshots() {
        return this.sendRequest(null, 17);
    }

    public CompletableFuture<CheckLeadershipResponse> checkLeadership() {
        return this.sendRequest(null, 18);
    }

    public void watch(EventWatcher eventWatcher) {
        if (null == this.eventBus) {
            this.initPullEvent();
        }
        this.eventBus.watch(eventWatcher);
    }

    private void initPullEvent() {
        try {
            AddPullWatchResponse addPullWatchResponse = this.addPullWatch().get();
            if (!addPullWatchResponse.success()) {
                throw new RpcException((BaseResponse)addPullWatchResponse);
            }
            this.eventBus = new EventBus();
            this.pullWatchId = addPullWatchResponse.getPullWatchId();
            this.ackSequence = -1L;
            long pullInterval = addPullWatchResponse.getPullIntervalMs();
            this.pullEventThread = this.buildPullEventsThread(pullInterval);
            this.pullEventThread.start();
        }
        catch (Throwable t) {
            throw new RpcException(t);
        }
    }

    private AsyncLoopThread buildPullEventsThread(long pullInterval) {
        return ThreadBuilder.builder().name("PullEventsThread").doWork(this::pullRemoteEvents).sleepTime(pullInterval, pullInterval).onException(e -> logger.warn("PullEventsThread Exception: ", e)).daemon(true).build();
    }

    private void pullRemoteEvents() {
        this.pullEvents(new PullEventsRequest(this.pullWatchId, this.ackSequence)).thenAccept(response -> {
            if (response.success()) {
                if (null != response.getPullEvents()) {
                    response.getPullEvents().forEach(pullEvent -> {
                        this.eventBus.fireEvent((Event)pullEvent);
                        this.ackSequence = pullEvent.getSequence();
                    });
                }
            } else {
                logger.warn("Pull event error: {}", (Object)response.getError());
            }
        });
    }

    public void unWatch(EventWatcher eventWatcher) {
        if (null != this.eventBus) {
            this.eventBus.unWatch(eventWatcher);
            if (!this.eventBus.hasEventWatchers()) {
                this.destroyPullEvent();
            }
        }
    }

    private void destroyPullEvent() {
        if (null != this.eventBus) {
            this.eventBus.shutdown();
            this.eventBus = null;
        }
        if (null != this.pullEventThread) {
            this.pullEventThread.stop();
            this.eventBus = null;
        }
        if (this.pullWatchId >= 0L) {
            try {
                RemovePullWatchResponse response = this.removePullWatch(new RemovePullWatchRequest(this.pullWatchId)).get();
                if (!response.success()) {
                    throw new RpcException((BaseResponse)response);
                }
            }
            catch (Throwable t) {
                logger.warn("Remove pull watch exception: ", t);
            }
            finally {
                this.pullWatchId = -1L;
            }
        }
    }

    private synchronized Transport createTransport() {
        return this.transportClient.createTransport(this.inetSocketAddress);
    }

    private synchronized void closeTransport() {
        if (null != this.transport) {
            this.transport.stop();
            this.transport = null;
        }
    }

    private boolean isAlive() {
        return null != this.transport && this.transport.state() == TransportState.CONNECTED;
    }

    public void stop() {
        this.destroyPullEvent();
        this.closeTransport();
    }
}

