/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.client;

import io.journalkeeper.rpc.RpcException;
import io.journalkeeper.rpc.UriSupport;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.ClientServerRpcAccessPoint;
import io.journalkeeper.rpc.client.ClientServerRpcStub;
import io.journalkeeper.rpc.remoting.transport.TransportClient;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class JournalKeeperClientServerRpcAccessPoint
implements ClientServerRpcAccessPoint {
    private final Properties properties;
    private final TransportClient transportClient;
    private Map<URI, ClientServerRpcStub> serverInstances = new ConcurrentHashMap<URI, ClientServerRpcStub>();
    public final String PROTOCOL_VERSION_KEY = "protocol.version";
    private final int protocolVersion;

    public JournalKeeperClientServerRpcAccessPoint(TransportClient transportClient, Properties properties) {
        this.transportClient = transportClient;
        try {
            this.transportClient.start();
        }
        catch (Exception e) {
            throw new RpcException((Throwable)e);
        }
        this.properties = properties;
        this.protocolVersion = Integer.parseInt(properties.getProperty("protocol.version", String.valueOf(2)));
    }

    public ClientServerRpc getClintServerRpc(URI uri) {
        if (null == uri) {
            throw new IllegalArgumentException("URI can not be null!");
        }
        return this.serverInstances.computeIfAbsent(uri, this::createClientServerRpc);
    }

    public void stop() {
        this.serverInstances.values().forEach(this::disconnect);
        this.transportClient.stop();
    }

    private ClientServerRpcStub createClientServerRpc(URI server) {
        return new ClientServerRpcStub(this.transportClient, server, UriSupport.parseUri((URI)server), this.protocolVersion);
    }

    private void disconnect(ClientServerRpcStub clientServerRpc) {
        if (null != clientServerRpc) {
            clientServerRpc.stop();
        }
    }
}

