/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.codec;

import io.journalkeeper.core.api.ClusterConfiguration;
import io.journalkeeper.rpc.client.GetServersResponse;
import io.journalkeeper.rpc.codec.ResponseCodec;
import io.journalkeeper.rpc.header.JournalKeeperHeader;
import io.journalkeeper.rpc.remoting.serialize.CodecSupport;
import io.journalkeeper.rpc.remoting.transport.command.Type;
import io.netty.buffer.ByteBuf;
import java.net.URI;
import java.util.List;

public class GetServersResponseCodec
extends ResponseCodec<GetServersResponse>
implements Type {
    @Override
    protected void encodeResponse(JournalKeeperHeader header, GetServersResponse response, ByteBuf buffer) throws Exception {
        ClusterConfiguration clusterConfiguration;
        ClusterConfiguration clusterConfiguration2 = clusterConfiguration = response == null ? new ClusterConfiguration() : response.getClusterConfiguration();
        if (null == clusterConfiguration) {
            clusterConfiguration = new ClusterConfiguration();
        }
        CodecSupport.encodeString(buffer, this.uriToString(clusterConfiguration.getLeader()));
        CodecSupport.encodeList(buffer, clusterConfiguration.getVoters(), (obj, buffer1) -> CodecSupport.encodeUri(buffer1, (URI)obj));
        CodecSupport.encodeList(buffer, clusterConfiguration.getObservers(), (obj, buffer1) -> CodecSupport.encodeUri(buffer1, (URI)obj));
    }

    @Override
    protected GetServersResponse decodeResponse(JournalKeeperHeader header, ByteBuf buffer) throws Exception {
        URI leader = CodecSupport.decodeUri(buffer);
        List voters = CodecSupport.decodeList(buffer, CodecSupport::decodeUri);
        List observers = CodecSupport.decodeList(buffer, CodecSupport::decodeUri);
        return new GetServersResponse(new ClusterConfiguration(leader, voters, observers));
    }

    @Override
    public int type() {
        return -6;
    }

    private String uriToString(URI uri) {
        return null == uri ? null : uri.toString();
    }
}

