/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.codec;

import io.journalkeeper.rpc.LeaderResponse;
import io.journalkeeper.rpc.codec.ResponseCodec;
import io.journalkeeper.rpc.header.JournalKeeperHeader;
import io.journalkeeper.rpc.remoting.serialize.CodecSupport;
import io.netty.buffer.ByteBuf;
import java.net.URI;

public abstract class LeaderResponseCodec<R extends LeaderResponse>
extends ResponseCodec<R> {
    @Override
    protected final void encodeResponse(JournalKeeperHeader header, R response, ByteBuf buffer) throws Exception {
        this.encodeLeaderResponse(header, response, buffer);
        CodecSupport.encodeString(buffer, response.getLeader() == null ? null : response.getLeader().toString());
    }

    @Override
    protected final R decodeResponse(JournalKeeperHeader header, ByteBuf buffer) throws Exception {
        R response = this.decodeLeaderResponse(header, buffer);
        String leaderStr = CodecSupport.decodeString(buffer);
        if (leaderStr.length() > 0) {
            response.setLeader(URI.create(leaderStr));
        }
        return response;
    }

    protected abstract void encodeLeaderResponse(JournalKeeperHeader var1, R var2, ByteBuf var3) throws Exception;

    protected abstract R decodeLeaderResponse(JournalKeeperHeader var1, ByteBuf var2) throws Exception;
}

