/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.codec;

import io.journalkeeper.rpc.client.PullEventsResponse;
import io.journalkeeper.rpc.codec.ResponseCodec;
import io.journalkeeper.rpc.header.JournalKeeperHeader;
import io.journalkeeper.rpc.remoting.serialize.CodecSupport;
import io.journalkeeper.rpc.remoting.transport.codec.Decoder;
import io.journalkeeper.rpc.remoting.transport.codec.Encoder;
import io.journalkeeper.rpc.remoting.transport.command.Type;
import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import io.journalkeeper.utils.event.PullEvent;
import io.netty.buffer.ByteBuf;

public class PullEventsResponseCodec
extends ResponseCodec<PullEventsResponse>
implements Type {
    @Override
    protected void encodeResponse(JournalKeeperHeader header, PullEventsResponse response, ByteBuf buffer) {
        CodecSupport.encodeList(buffer, response.getPullEvents(), (obj, buffer1) -> {
            PullEvent pullEvent = (PullEvent)obj;
            CodecSupport.encodeInt(buffer1, pullEvent.getEventType());
            CodecSupport.encodeLong(buffer1, pullEvent.getSequence());
            CodecSupport.encodeMap(buffer1, pullEvent.getEventData(), new StringCodec(), new StringCodec());
        });
    }

    @Override
    protected PullEventsResponse decodeResponse(JournalKeeperHeader header, ByteBuf buffer) {
        return new PullEventsResponse(CodecSupport.decodeList(buffer, buffer1 -> new PullEvent(CodecSupport.decodeInt(buffer1), CodecSupport.decodeLong(buffer1), CodecSupport.decodeMap(buffer1, new StringCodec(), new StringCodec()))));
    }

    @Override
    public int type() {
        return -11;
    }

    private static class StringCodec
    implements Encoder,
    Decoder {
        private StringCodec() {
        }

        @Override
        public Object decode(ByteBuf buffer) throws TransportException.CodecException {
            return CodecSupport.decodeString(buffer);
        }

        @Override
        public void encode(Object obj, ByteBuf buffer) throws TransportException.CodecException {
            CodecSupport.encodeString(buffer, (String)obj);
        }
    }
}

