/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.codec;

import io.journalkeeper.rpc.codec.GenericPayloadCodec;
import io.journalkeeper.rpc.header.JournalKeeperHeader;
import io.journalkeeper.rpc.remoting.serialize.CodecSupport;
import io.journalkeeper.rpc.remoting.transport.command.Type;
import io.journalkeeper.rpc.server.RequestVoteRequest;
import io.netty.buffer.ByteBuf;

public class RequestVoteRequestCodec
extends GenericPayloadCodec<RequestVoteRequest>
implements Type {
    @Override
    protected void encodePayload(JournalKeeperHeader header, RequestVoteRequest request, ByteBuf buffer) {
        CodecSupport.encodeInt(buffer, request.getTerm());
        CodecSupport.encodeUri(buffer, request.getCandidate());
        CodecSupport.encodeLong(buffer, request.getLastLogIndex());
        CodecSupport.encodeInt(buffer, request.getLastLogTerm());
        CodecSupport.encodeBoolean(buffer, request.isFromPreferredLeader());
        if (header.getVersion() > 1) {
            CodecSupport.encodeBoolean(buffer, request.isPreVote());
        }
    }

    @Override
    protected RequestVoteRequest decodePayload(JournalKeeperHeader header, ByteBuf buffer) {
        if (header.getVersion() > 1) {
            return new RequestVoteRequest(CodecSupport.decodeInt(buffer), CodecSupport.decodeUri(buffer), CodecSupport.decodeLong(buffer), CodecSupport.decodeInt(buffer), CodecSupport.decodeBoolean(buffer), CodecSupport.decodeBoolean(buffer));
        }
        return new RequestVoteRequest(CodecSupport.decodeInt(buffer), CodecSupport.decodeUri(buffer), CodecSupport.decodeLong(buffer), CodecSupport.decodeInt(buffer), CodecSupport.decodeBoolean(buffer), false);
    }

    @Override
    public int type() {
        return 102;
    }
}

