/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.handler;

import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.handler.AddPullWatchHandler;
import io.journalkeeper.rpc.handler.AsyncAppendEntriesHandler;
import io.journalkeeper.rpc.handler.CheckLeadershipHandler;
import io.journalkeeper.rpc.handler.CompleteTransactionHandler;
import io.journalkeeper.rpc.handler.ConvertRollHandler;
import io.journalkeeper.rpc.handler.CreateTransactionHandler;
import io.journalkeeper.rpc.handler.DisableLeaderWriteRequestHandler;
import io.journalkeeper.rpc.handler.GetOpeningTransactionsHandler;
import io.journalkeeper.rpc.handler.GetServerEntriesHandler;
import io.journalkeeper.rpc.handler.GetServerStateHandler;
import io.journalkeeper.rpc.handler.GetServerStatusHandler;
import io.journalkeeper.rpc.handler.GetServersHandler;
import io.journalkeeper.rpc.handler.GetSnapshotsHandler;
import io.journalkeeper.rpc.handler.InstallSnapshotHandler;
import io.journalkeeper.rpc.handler.LastAppliedHandler;
import io.journalkeeper.rpc.handler.PullEventsHandler;
import io.journalkeeper.rpc.handler.QueryClusterStateHandler;
import io.journalkeeper.rpc.handler.QueryServerStateHandler;
import io.journalkeeper.rpc.handler.QuerySnapshotHandler;
import io.journalkeeper.rpc.handler.RemovePullWatchHandler;
import io.journalkeeper.rpc.handler.RequestVoteHandler;
import io.journalkeeper.rpc.handler.UpdateClusterStateHandler;
import io.journalkeeper.rpc.handler.UpdateVotersHandler;
import io.journalkeeper.rpc.remoting.transport.command.support.UriRoutedCommandHandlerFactory;
import io.journalkeeper.rpc.server.ServerRpc;
import java.net.URI;

public class ServerRpcCommandHandlerRegistry {
    public static void register(UriRoutedCommandHandlerFactory factory, ServerRpc serverRpc) {
        URI uri = serverRpc.serverUri();
        factory.register(uri, new UpdateClusterStateHandler(serverRpc));
        factory.register(uri, new LastAppliedHandler(serverRpc));
        factory.register(uri, new QueryClusterStateHandler(serverRpc));
        factory.register(uri, new QueryServerStateHandler(serverRpc));
        factory.register(uri, new QuerySnapshotHandler(serverRpc));
        factory.register(uri, new GetServersHandler(serverRpc));
        factory.register(uri, new AddPullWatchHandler(serverRpc));
        factory.register(uri, new RemovePullWatchHandler(serverRpc));
        factory.register(uri, new PullEventsHandler(serverRpc));
        factory.register(uri, new UpdateVotersHandler(serverRpc));
        factory.register(uri, new ConvertRollHandler(serverRpc));
        factory.register(uri, new GetServerStatusHandler((ClientServerRpc)serverRpc));
        factory.register(uri, new CreateTransactionHandler(serverRpc));
        factory.register(uri, new GetOpeningTransactionsHandler(serverRpc));
        factory.register(uri, new CompleteTransactionHandler(serverRpc));
        factory.register(uri, new GetSnapshotsHandler(serverRpc));
        factory.register(uri, new CheckLeadershipHandler(serverRpc));
        factory.register(uri, new AsyncAppendEntriesHandler(serverRpc));
        factory.register(uri, new RequestVoteHandler(serverRpc));
        factory.register(uri, new GetServerEntriesHandler(serverRpc));
        factory.register(uri, new GetServerStateHandler(serverRpc));
        factory.register(uri, new DisableLeaderWriteRequestHandler(serverRpc));
        factory.register(uri, new InstallSnapshotHandler(serverRpc));
    }
}

