/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.header;

import io.journalkeeper.rpc.remoting.transport.command.Direction;
import io.journalkeeper.rpc.remoting.transport.command.Header;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;

public class JournalKeeperHeader
implements Header {
    public static final int MAGIC = 1062114263;
    private static final AtomicInteger requestIdGenerator = new AtomicInteger(0);
    public static final int DEFAULT_VERSION = 2;
    private boolean oneWay;
    private int status;
    private String error;
    private int requestId;
    private Direction direction;
    private int version;
    private int type;
    private long sendTime;
    private URI destination;

    public JournalKeeperHeader() {
    }

    public JournalKeeperHeader(int version, Direction direction, int type, URI destination) {
        this(version, false, direction, JournalKeeperHeader.nextRequestId(), type, System.currentTimeMillis(), destination, 0, null);
    }

    public JournalKeeperHeader(int version, Direction direction, int requestId, int type, URI destination) {
        this(version, false, direction, requestId, type, System.currentTimeMillis(), destination, 0, null);
    }

    public JournalKeeperHeader(int version, boolean oneWay, Direction direction, int requestId, int type, long sendTime, URI destination, int status, String error) {
        this.version = version;
        this.oneWay = oneWay;
        this.direction = direction;
        this.requestId = requestId;
        this.type = type;
        this.sendTime = sendTime;
        this.status = status;
        this.error = error;
        this.destination = destination;
    }

    private static int nextRequestId() {
        return requestIdGenerator.incrementAndGet();
    }

    @Override
    public boolean isOneWay() {
        return this.oneWay;
    }

    @Override
    public void setOneWay(boolean oneWay) {
        this.oneWay = oneWay;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public void setError(String error) {
        this.error = error;
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    public long getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(long sendTime) {
        this.sendTime = sendTime;
    }

    @Override
    public URI getDestination() {
        return this.destination;
    }

    @Override
    public void setDestination(URI destination) {
        this.destination = destination;
    }
}

