/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.header;

import io.journalkeeper.rpc.header.JournalKeeperHeader;
import io.journalkeeper.rpc.remoting.serialize.CodecSupport;
import io.journalkeeper.rpc.remoting.transport.codec.Codec;
import io.journalkeeper.rpc.remoting.transport.command.Direction;
import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import io.netty.buffer.ByteBuf;
import java.net.URI;

public class JournalKeeperHeaderCodec
implements Codec {
    private static final int HEADER_LENGTH = 19;

    @Override
    public JournalKeeperHeader decode(ByteBuf buffer) throws TransportException.CodecException {
        boolean oneWay;
        if (buffer.readableBytes() < 19) {
            return null;
        }
        int magic = buffer.readInt();
        if (magic != 1062114263) {
            return null;
        }
        byte version = buffer.readByte();
        byte identity = buffer.readByte();
        int requestId = buffer.readInt();
        byte type = buffer.readByte();
        long sendTime = buffer.readLong();
        short status = 0;
        String error = null;
        Direction direction = Direction.valueOf(identity & 1);
        boolean bl = oneWay = (identity >> 1 & 1) == 1;
        if (direction.equals((Object)Direction.RESPONSE)) {
            status = buffer.readUnsignedByte();
            try {
                error = CodecSupport.decodeString(buffer);
            }
            catch (Exception e) {
                throw new TransportException.CodecException(e.getMessage());
            }
        }
        URI destination = null;
        if (direction.equals((Object)Direction.REQUEST)) {
            destination = URI.create(CodecSupport.decodeString(buffer));
        }
        return new JournalKeeperHeader(version, oneWay, direction, requestId, type, sendTime, destination, status, error);
    }

    @Override
    public void encode(Object payload, ByteBuf buffer) throws TransportException.CodecException {
        JournalKeeperHeader header = (JournalKeeperHeader)payload;
        byte identity = (byte)(header.getDirection().ordinal() & 1 | (header.isOneWay() ? 2 : 0));
        buffer.writeInt(1062114263);
        buffer.writeByte(header.getVersion());
        buffer.writeByte((int)identity);
        buffer.writeInt(header.getRequestId());
        buffer.writeByte(header.getType());
        buffer.writeLong(header.getSendTime());
        if (header.getDirection().equals((Object)Direction.RESPONSE)) {
            buffer.writeByte(header.getStatus());
            try {
                CodecSupport.encodeString(buffer, header.getError());
            }
            catch (Exception e) {
                throw new TransportException.CodecException(e.getMessage());
            }
        }
        if (header.getDirection().equals((Object)Direction.REQUEST)) {
            CodecSupport.encodeString(buffer, header.getDestination().toASCIIString());
        }
    }
}

