/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.concurrent;

import io.journalkeeper.rpc.remoting.concurrent.EventListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class EventBus<E> {
    protected CopyOnWriteArrayList<EventListener<E>> listeners = new CopyOnWriteArrayList();
    protected BlockingQueue<Ownership> events;
    protected String name;
    protected EventDispatcher dispatcher;
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected long interval;
    protected long idleTime;
    protected long timeout = 1000L;

    public EventBus() {
        this(null, 0);
    }

    public EventBus(EventListener<E> listener) {
        this(null, listener, 0);
    }

    public EventBus(String name) {
        this(name, 0);
    }

    public EventBus(String name, int capacity) {
        this.name = name;
        this.events = capacity > 0 ? new ArrayBlockingQueue<Ownership>(capacity) : new LinkedBlockingDeque<Ownership>();
    }

    public EventBus(String name, EventListener<E> listener) {
        this(name, 0);
        this.addListener(listener);
    }

    public EventBus(String name, EventListener<E> listener, int capacity) {
        this(name, capacity);
        this.addListener(listener);
    }

    public EventBus(String name, List<? extends EventListener<E>> listeners) {
        this(name, 0);
        if (listeners != null) {
            for (EventListener<E> listener : listeners) {
                this.addListener(listener);
            }
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(long idleTime) {
        this.idleTime = idleTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        if (timeout > 0L) {
            this.timeout = timeout;
        }
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.events.clear();
            this.dispatcher = new EventDispatcher();
            Thread thread = this.name != null ? new Thread((Runnable)this.dispatcher, this.name) : new Thread(this.dispatcher);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean gracefully) {
        if (this.started.compareAndSet(true, false) && this.dispatcher != null) {
            this.dispatcher.stop(gracefully);
            this.events.clear();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean addListener(EventListener<E> listener) {
        if (listener != null) {
            return this.listeners.addIfAbsent(listener);
        }
        return false;
    }

    public boolean removeListener(EventListener<E> listener) {
        if (listener != null) {
            return this.listeners.remove(listener);
        }
        return false;
    }

    public List<EventListener<E>> getListeners() {
        return this.listeners;
    }

    public boolean add(E event) {
        return this.add(event, null);
    }

    public boolean add(E event, long timeout, TimeUnit unit) {
        return this.add(event, null, timeout, unit);
    }

    public boolean add(E event, EventListener<E> owner) {
        if (event == null) {
            return false;
        }
        try {
            this.events.put(new Ownership(event, owner));
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean add(E event, EventListener<E> owner, long timeout, TimeUnit unit) {
        if (event == null) {
            return false;
        }
        try {
            return this.events.offer(new Ownership(event, owner), timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void inform(E event) {
        if (event == null) {
            return;
        }
        for (EventListener<E> listener : this.listeners) {
            try {
                listener.onEvent(event);
            }
            catch (Throwable throwable) {}
        }
    }

    protected void onIdle() {
    }

    protected void publish(List<Ownership> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        this.publish(events.get(events.size() - 1));
    }

    protected void publish(Ownership event) {
        if (event != null && event.owner != null) {
            try {
                event.owner.onEvent(event.event);
            }
            catch (Throwable throwable) {}
        } else {
            Object e = event == null ? null : (Object)event.event;
            for (EventListener<Object> eventListener : this.listeners) {
                if (e == null && (!(eventListener instanceof EventListener.Heartbeat) || !((EventListener.Heartbeat)((Object)eventListener)).trigger(System.currentTimeMillis()))) continue;
                try {
                    eventListener.onEvent(e);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected class EventDispatcher
    implements Runnable {
        private CountDownLatch latch = new CountDownLatch(1);
        private AtomicReference<State> state = new AtomicReference<State>(State.STARTED);

        protected EventDispatcher() {
        }

        public void stop(boolean gracefully) {
            this.state.set(gracefully ? State.STOPPED_GRACEFULLY : State.STOPPED);
            if (gracefully) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void run() {
            long lastTime = System.currentTimeMillis();
            block3: while (true) {
                try {
                    while (true) {
                        boolean sleeping = EventBus.this.interval > 0L;
                        Ownership event = null;
                        State status = this.state.get();
                        if (status == State.STARTED) {
                            event = EventBus.this.events.poll(EventBus.this.timeout, TimeUnit.MILLISECONDS);
                            status = this.state.get();
                        }
                        if (status == State.STOPPED) break block3;
                        if (status == State.STOPPED_GRACEFULLY && event == null) {
                            event = (Ownership)EventBus.this.events.poll();
                        }
                        if (event == null && status == State.STOPPED_GRACEFULLY) break block3;
                        if (event != null) {
                            if (EventBus.this.idleTime > 0L) {
                                lastTime = System.currentTimeMillis();
                            }
                            if (EventBus.this.interval > 0L) {
                                ArrayList<Ownership> currents = new ArrayList<Ownership>();
                                currents.add(event);
                                while (!EventBus.this.events.isEmpty()) {
                                    event = (Ownership)EventBus.this.events.poll();
                                    if (event == null) continue;
                                    currents.add(event);
                                }
                                EventBus.this.publish(currents);
                            } else {
                                EventBus.this.publish(event);
                            }
                        } else {
                            long now;
                            EventBus.this.publish((Ownership)null);
                            if (EventBus.this.idleTime > 0L && (now = System.currentTimeMillis()) - lastTime > EventBus.this.idleTime) {
                                lastTime = now;
                                if (!EventBus.this.events.isEmpty()) {
                                    sleeping = false;
                                } else {
                                    EventBus.this.onIdle();
                                }
                            }
                        }
                        if (!sleeping || status != State.STARTED) continue;
                        Thread.sleep(EventBus.this.interval);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    protected class Ownership {
        public E event;
        public EventListener<E> owner;

        public Ownership(E event, EventListener<E> owner) {
            this.event = event;
            this.owner = owner;
        }
    }

    protected static enum State {
        STARTED,
        STOPPED,
        STOPPED_GRACEFULLY;

    }
}

