/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.handler;

import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ConnectionHandler.class);

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        logger.info("connection is connected, address: {}", (Object)ctx.channel().remoteAddress());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        logger.info("connection is closed, address: {}", (Object)ctx.channel().remoteAddress());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        try {
            channel.close().await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (cause.getMessage().contains("Connection reset by peer")) {
            logger.error("channel close, address: {}, connection reset by peer", (Object)channel.remoteAddress());
            return;
        }
        if (TransportException.isClosed(cause)) {
            logger.error("channel exception, address: {}", (Object)channel.remoteAddress(), (Object)cause);
        } else {
            logger.error("channel exception, address: {}", (Object)channel.remoteAddress());
        }
    }
}

