/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.service;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Activity {
    protected final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.rwLock.readLock();
    protected final Lock writeLock = this.rwLock.writeLock();
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected final AtomicReference<ServiceState> serviceState = new AtomicReference();
    protected final Object signal = new Object();
    private final Logger logger = LoggerFactory.getLogger(Activity.class);

    protected void start() throws Exception {
        block6: {
            this.validate();
            this.serviceState.set(ServiceState.WILL_START);
            this.beforeStart();
            this.writeLock.lock();
            try {
                if (!this.started.compareAndSet(false, true)) break block6;
                try {
                    this.serviceState.set(ServiceState.STARTING);
                    this.doStart();
                    this.afterStart();
                    this.serviceState.set(ServiceState.STARTED);
                }
                catch (Exception e) {
                    this.serviceState.set(ServiceState.START_FAILED);
                    this.startError(e);
                    this.stop();
                    Exception ex = this.convert(e);
                    if (ex != null) {
                        throw ex;
                    }
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    protected void beforeStart() throws Exception {
    }

    protected void validate() throws Exception {
    }

    protected void doStart() throws Exception {
    }

    protected void afterStart() throws Exception {
    }

    protected void startError(Exception e) {
        this.logger.error("start error ", (Throwable)e);
    }

    protected Exception convert(Exception e) {
        return e;
    }

    protected void stop() {
        this.stop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(Runnable runnable) {
        this.serviceState.set(ServiceState.WILL_STOP);
        Object object = this.signal;
        synchronized (object) {
            this.signal.notifyAll();
        }
        this.beforeStop();
        this.writeLock.lock();
        try {
            if (this.started.compareAndSet(true, false)) {
                this.serviceState.set(ServiceState.STOPPING);
                this.doStop();
                this.afterStop();
                if (runnable != null) {
                    runnable.run();
                }
                this.serviceState.set(ServiceState.STOPPED);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void beforeStop() {
    }

    protected void doStop() {
    }

    protected void afterStop() {
    }

    protected void willStop() {
        this.serviceState.set(ServiceState.WILL_STOP);
        this.beforeStop();
    }

    protected ServiceState getServiceState() {
        return this.serviceState.get();
    }

    protected boolean isStarted() {
        if (this.started.get()) {
            switch (this.serviceState.get()) {
                case WILL_STOP: {
                    return false;
                }
                case STOPPING: {
                    return false;
                }
                case STOPPED: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isStopped() {
        switch (this.serviceState.get()) {
            case START_FAILED: {
                return true;
            }
            case WILL_STOP: {
                return true;
            }
            case STOPPING: {
                return true;
            }
            case STOPPED: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void await(long time) {
        if (!this.isStarted()) {
            return;
        }
        Object object = this.signal;
        synchronized (object) {
            try {
                this.signal.wait(time);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected boolean isReady() {
        return this.serviceState.get() == ServiceState.STARTED;
    }

    protected Lock getWriteLock() {
        return this.writeLock;
    }

    protected Lock getReadLock() {
        return this.rwLock.readLock();
    }

    public static enum ServiceState {
        WILL_START,
        STARTING,
        START_FAILED,
        STARTED,
        WILL_STOP,
        STOPPING,
        STOPPED;

    }
}

