/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport;

import io.journalkeeper.rpc.remoting.transport.IpUtil;
import io.journalkeeper.rpc.remoting.transport.ResponseFuture;
import io.journalkeeper.rpc.remoting.transport.config.TransportConfig;
import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBarrier {
    protected static Logger logger = LoggerFactory.getLogger(RequestBarrier.class);
    public Semaphore onewaySemaphore;
    public Semaphore asyncSemaphore;
    public Map<Integer, ResponseFuture> futures = new ConcurrentHashMap<Integer, ResponseFuture>(200);
    private TransportConfig config;

    public RequestBarrier(TransportConfig config) {
        this.config = config;
        this.onewaySemaphore = config.getMaxOneway() > 0 ? new Semaphore(config.getMaxOneway(), true) : null;
        this.asyncSemaphore = config.getMaxAsync() > 0 ? new Semaphore(config.getMaxAsync(), true) : null;
    }

    public int getSendTimeout() {
        return this.config.getSendTimeout();
    }

    public ResponseFuture get(int requestId) {
        return this.futures.get(requestId);
    }

    public void put(int requestId, ResponseFuture future) {
        this.futures.put(requestId, future);
    }

    public ResponseFuture remove(int requestId) {
        return this.futures.remove(requestId);
    }

    public void evict() {
        Iterator<Map.Entry<Integer, ResponseFuture>> iterator = this.futures.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ResponseFuture> entry = iterator.next();
            ResponseFuture future = entry.getValue();
            long timeout = future.getBeginTime() + future.getTimeout();
            if (timeout > System.currentTimeMillis() || future.getResponse() != null) continue;
            iterator.remove();
            if (future.release()) {
                try {
                    future.onFailed(TransportException.RequestTimeoutException.build(IpUtil.toAddress(future.getTransport().remoteAddress())));
                }
                catch (Throwable e) {
                    logger.error("clear timeout response exception", e);
                }
            }
            logger.info("remove timeout request id={} begin={} timeout={}", new Object[]{future.getRequestId(), future.getBeginTime(), timeout});
        }
    }

    public void clear() {
        for (Map.Entry<Integer, ResponseFuture> entry : this.futures.entrySet()) {
            ResponseFuture future = entry.getValue();
            if (!future.release()) continue;
            try {
                future.onFailed(TransportException.RequestTimeoutException.build(IpUtil.toAddress(future.getTransport().remoteAddress())));
            }
            catch (Throwable throwable) {}
        }
        this.futures.clear();
    }

    public void acquire(SemaphoreType type, long timeout) throws TransportException {
        if (type == null) {
            return;
        }
        Semaphore semaphore = type == SemaphoreType.ASYNC ? this.asyncSemaphore : this.onewaySemaphore;
        try {
            boolean acquire = semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            if (!acquire) {
                throw TransportException.RequestExcessiveException.build();
            }
        }
        catch (InterruptedException e) {
            throw TransportException.InterruptedException.build();
        }
    }

    public void release(SemaphoreType type) {
        if (type == null) {
            return;
        }
        Semaphore semaphore = type == SemaphoreType.ASYNC ? this.asyncSemaphore : this.onewaySemaphore;
        semaphore.release();
    }

    public TransportConfig getConfig() {
        return this.config;
    }

    public static enum SemaphoreType {
        ASYNC,
        ONEWAY;

    }
}

