/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport;

import io.journalkeeper.rpc.remoting.transport.Transport;
import io.journalkeeper.rpc.remoting.transport.command.Command;
import io.journalkeeper.rpc.remoting.transport.command.CommandCallback;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseFuture
implements Future {
    protected static Logger logger = LoggerFactory.getLogger(ResponseFuture.class);
    private final long beginTime = System.currentTimeMillis();
    private Command request;
    private Command response;
    private Throwable cause;
    private long timeout;
    private int requestId;
    private Transport transport;
    private CommandCallback callback;
    private boolean success;
    private AtomicBoolean onceCallback = new AtomicBoolean(false);
    private AtomicBoolean released = new AtomicBoolean(false);
    private CountDownLatch latch;
    private Semaphore semaphore;
    private volatile boolean isDone = false;
    private volatile boolean isCancel = false;

    public ResponseFuture(Transport transport, Command request, long timeout, CommandCallback callback, Semaphore semaphore, CountDownLatch latch) {
        if (request == null) {
            throw new IllegalArgumentException("request can not be null");
        }
        this.transport = transport;
        this.request = request;
        if (request != null && request.getHeader() != null) {
            this.requestId = request.getHeader().getRequestId();
        }
        this.timeout = timeout;
        this.callback = callback;
        this.semaphore = semaphore;
        this.latch = latch;
    }

    public Command getRequest() {
        return this.request;
    }

    public Command getResponse() {
        return this.response;
    }

    public void setResponse(Command response) {
        this.response = response;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public CommandCallback getCallback() {
        return this.callback;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.beginTime + this.timeout;
    }

    public Command await() throws InterruptedException {
        if (this.latch != null) {
            this.latch.await(this.timeout, TimeUnit.MILLISECONDS);
        }
        return this.response;
    }

    public Command await(long timeout) throws InterruptedException {
        if (this.latch != null) {
            this.latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        return this.response;
    }

    public void callback() {
        if (this.callback == null) {
            return;
        }
        if (this.onceCallback.compareAndSet(false, true)) {
            try {
                if (this.isSuccess()) {
                    this.callback.onSuccess(this.request, this.response);
                } else if (this.cause != null) {
                    this.callback.onException(this.request, this.cause);
                } else {
                    logger.error("bigbug: success and exception confused! {}", (Object)this.request);
                }
            }
            catch (Throwable ignored) {
                logger.error("callback error", ignored);
            }
        }
    }

    public void onSuccess() {
        this.setSuccess(true);
        this.callback();
    }

    public void onFailed(Throwable cause) {
        this.setSuccess(false);
        this.setCause(cause);
        this.callback();
    }

    public boolean release() {
        return this.release(null, false);
    }

    public boolean released() {
        return this.released.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Throwable e, boolean callback) {
        if (this.released.compareAndSet(false, true)) {
            if (e != null) {
                this.success = false;
                this.cause = e;
            }
            if (this.request != null) {
                this.request.release();
            }
            if (this.semaphore != null) {
                this.semaphore.release();
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
            if (callback) {
                this.callback();
            }
            this.isDone = true;
            if (!this.isCancel) {
                ResponseFuture responseFuture = this;
                synchronized (responseFuture) {
                    this.notifyAll();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isCancel) {
            return false;
        }
        this.isCancel = true;
        ResponseFuture responseFuture = this;
        synchronized (responseFuture) {
            this.notifyAll();
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancel;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws InterruptedException, ExecutionException {
        if (this.isDone) {
            return this.getFutureResponse();
        }
        ResponseFuture responseFuture = this;
        synchronized (responseFuture) {
            this.wait();
        }
        if (this.isCancel) {
            throw new InterruptedException();
        }
        return this.getFutureResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isDone()) {
            return this.getFutureResponse();
        }
        ResponseFuture responseFuture = this;
        synchronized (responseFuture) {
            this.wait(unit.toMillis(timeout));
        }
        if (this.isCancel) {
            throw new InterruptedException();
        }
        if (!this.isDone) {
            throw new TimeoutException();
        }
        return this.getFutureResponse();
    }

    protected Object getFutureResponse() throws ExecutionException {
        if (this.cause != null) {
            throw new ExecutionException(this.cause);
        }
        return this.response;
    }
}

