/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport;

import io.journalkeeper.rpc.remoting.transport.IpUtil;

public class Segment {
    public static final String[] MASKES = new String[]{"128.0.0.0", "192.0.0.0", "224.0.0.0", "240.0.0.0", "248.0.0.0", "252.0.0.0", "254.0.0.0", "255.0.0.0", "255.128.0.0", "255.192.0.0", "255.224.0.0", "255.240.0.0", "255.248.0.0", "255.252.0.0", "255.254.0.0", "255.255.0.0", "255.255.128.0", "255.255.192.0", "255.255.224.0", "255.255.240.0", "255.255.248.0", "255.255.252.0", "255.255.254.0", "255.255.255.0", "255.255.255.128", "255.255.255.192", "255.255.255.224", "255.255.255.240", "255.255.255.248", "255.255.255.252", "255.255.255.254", "255.255.255.255"};
    private long begin;
    private long end;

    public Segment(String ips) {
        if (ips == null || ips.isEmpty()) {
            throw new IllegalArgumentException("ips is empty.");
        }
        int pos = ips.indexOf(45);
        if (pos == 0 || pos == ips.length() - 1) {
            throw new IllegalArgumentException(String.format("ips is invalid. %s", ips));
        }
        if (pos > 0) {
            this.begin = IpUtil.toLong(ips.substring(0, pos));
            this.end = IpUtil.toLong(ips.substring(pos + 1));
        } else {
            pos = ips.indexOf(47);
            if (pos == 0 || pos == ips.length() - 1) {
                throw new IllegalArgumentException(String.format("ips is invalid. %s", ips));
            }
            if (pos > 0) {
                int bits = Integer.parseInt(ips.substring(pos + 1));
                if (bits < 1 || bits > 32) {
                    throw new IllegalArgumentException(String.format("ips is invalid. %s", ips));
                }
                long mask = (int)IpUtil.toLong(MASKES[bits - 1]);
                this.begin = IpUtil.toLong(ips.substring(0, pos)) & mask;
                this.end = this.begin + (long)(~((int)mask));
            } else {
                this.begin = IpUtil.toLong(ips.replaceAll("\\*", "0"));
                this.end = IpUtil.toLong(ips.replaceAll("\\*", "255"));
            }
        }
    }

    public long getBegin() {
        return this.begin;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        if (this.begin != segment.begin) {
            return false;
        }
        return this.end == segment.end;
    }

    public int hashCode() {
        int result = (int)(this.begin ^ this.begin >>> 32);
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        return result;
    }

    public String toString() {
        return IpUtil.toIp(this.begin) + "-" + IpUtil.toIp(this.end);
    }

    public boolean contains(String ip) {
        long value = IpUtil.toLong(ip);
        return value >= this.begin && value <= this.end;
    }
}

