/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport;

import io.journalkeeper.rpc.remoting.service.Service;
import io.journalkeeper.rpc.remoting.transport.IpUtil;
import io.journalkeeper.rpc.remoting.transport.config.ClientConfig;
import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import io.journalkeeper.utils.threads.NamedThreadFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransportClientSupport
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(TransportClientSupport.class);
    private ClientConfig config;
    private EventLoopGroup ioEventGroup;
    private Bootstrap bootstrap;

    public TransportClientSupport(ClientConfig config) {
        this.config = config;
    }

    public static InetSocketAddress createInetSocketAddress(String address) throws TransportException {
        int port;
        if (address == null || address.isEmpty()) {
            throw new IllegalArgumentException("address must not be empty!");
        }
        String[] parts = address.split("[._:]");
        if (parts.length < 1) {
            throw new IllegalArgumentException("address is invalid.");
        }
        try {
            port = Integer.parseInt(parts[parts.length - 1]);
            if (port < 0) {
                throw new IllegalArgumentException("address is invalid.");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("address is invalid.");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            if (i > 0) {
                builder.append('.');
            }
            builder.append(parts[i]);
        }
        String ip = builder.toString();
        try {
            return new InetSocketAddress(InetAddress.getByName(ip), port);
        }
        catch (UnknownHostException e) {
            throw TransportException.UnknownHostException.build(ip);
        }
    }

    @Override
    protected void doStop() {
        if (this.ioEventGroup != null) {
            this.ioEventGroup.shutdownGracefully();
        }
    }

    protected Bootstrap newBootstrap(ChannelHandler channelHandler, EventLoopGroup ioEventGroup) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.channel(Epoll.isAvailable() ? EpollSocketChannel.class : NioSocketChannel.class)).group(ioEventGroup)).handler(channelHandler)).option(ChannelOption.SO_REUSEADDR, (Object)this.config.isReuseAddress())).option(ChannelOption.SO_RCVBUF, (Object)this.config.getSocketBufferSize())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        return bootstrap;
    }

    protected EventLoopGroup newIoEventGroup() {
        NamedThreadFactory threadFactory = new NamedThreadFactory("Transport-Client-IO-LoopGroup");
        int ioThread = this.config.getIoThread();
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(ioThread, (ThreadFactory)threadFactory);
        }
        return new NioEventLoopGroup(ioThread, (ThreadFactory)threadFactory);
    }

    protected abstract ChannelHandler newChannelHandlerPipeline();

    public ClientConfig getConfig() {
        return this.config;
    }

    protected synchronized Channel createChannel(SocketAddress address, long connectionTimeout) throws TransportException {
        if (address == null) {
            throw new IllegalArgumentException("address must not be null!");
        }
        if (this.ioEventGroup == null) {
            this.ioEventGroup = this.newIoEventGroup();
        }
        if (this.bootstrap == null) {
            ChannelHandler channelHandlerPipeline = this.newChannelHandlerPipeline();
            this.bootstrap = this.newBootstrap(channelHandlerPipeline, this.ioEventGroup);
        }
        try {
            long timeout = connectionTimeout > 0L ? connectionTimeout : (long)this.config.getConnectionTimeout();
            String addr = IpUtil.toAddress(address);
            Channel channel = null;
            ChannelFuture channelFuture = this.bootstrap.connect(address);
            if (!channelFuture.await(timeout)) {
                throw TransportException.ConnectionTimeoutException.build(addr);
            }
            channel = channelFuture.channel();
            if (channel == null || !channel.isActive()) {
                throw TransportException.ConnectionException.build(addr);
            }
            return channel;
        }
        catch (InterruptedException e) {
            throw TransportException.InterruptedException.build();
        }
        catch (Exception e) {
            if (e instanceof TransportException) {
                throw (TransportException)e;
            }
            throw new TransportException.UnknownException();
        }
    }
}

