/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport;

import io.journalkeeper.rpc.remoting.transport.ChannelTransport;
import io.journalkeeper.rpc.remoting.transport.RequestBarrier;
import io.journalkeeper.rpc.remoting.transport.support.DefaultChannelTransport;
import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;

public class TransportHelper {
    private static final AttributeKey<ChannelTransport> TRANSPORT_CACHE_ATTR = AttributeKey.valueOf((String)"TRANSPORT_CACHE");

    public static ChannelTransport getOrNewTransport(Channel channel, RequestBarrier requestBarrier) {
        Attribute attr = channel.attr(TRANSPORT_CACHE_ATTR);
        ChannelTransport transport = (ChannelTransport)attr.get();
        if (transport == null) {
            transport = TransportHelper.newTransport(channel, requestBarrier);
            attr.set((Object)transport);
        }
        return transport;
    }

    public static ChannelTransport newTransport(Channel channel, RequestBarrier requestBarrier) {
        return new DefaultChannelTransport(channel, requestBarrier);
    }

    public static void setTransport(Channel channel, ChannelTransport transport) {
        channel.attr(TRANSPORT_CACHE_ATTR).set((Object)transport);
    }

    public static ChannelTransport getTransport(Channel channel) {
        return (ChannelTransport)channel.attr(TRANSPORT_CACHE_ATTR).get();
    }
}

