/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport;

import io.journalkeeper.rpc.remoting.service.Service;
import io.journalkeeper.rpc.remoting.transport.TransportServer;
import io.journalkeeper.rpc.remoting.transport.config.ServerConfig;
import io.journalkeeper.utils.threads.NamedThreadFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransportServerSupport
extends Service
implements TransportServer {
    protected static final Logger logger = LoggerFactory.getLogger(TransportServerSupport.class);
    private ServerConfig serverConfig;
    private String host;
    private int port;
    private EventLoopGroup acceptEventGroup;
    private EventLoopGroup ioEventGroup;
    private ServerBootstrap serverBootstrap;
    private Channel channel;

    public TransportServerSupport(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.host = serverConfig.getHost();
        this.port = serverConfig.getPort();
    }

    public TransportServerSupport(ServerConfig serverConfig, String host) {
        this.serverConfig = serverConfig;
        this.host = host;
        this.port = serverConfig.getPort();
    }

    public TransportServerSupport(ServerConfig serverConfig, String host, int port) {
        this.serverConfig = serverConfig;
        this.host = host;
        this.port = port;
    }

    @Override
    protected void doStart() throws Exception {
        EventLoopGroup acceptEventGroup = this.newAcceptEventGroup();
        EventLoopGroup ioEventGroup = this.newIoEventGroup();
        ChannelHandler channelHandlerPipeline = this.newChannelHandlerPipeline();
        ServerBootstrap serverBootstrap = this.newBootstrap(channelHandlerPipeline, acceptEventGroup, ioEventGroup);
        Channel channel = this.doBind(serverBootstrap);
        this.acceptEventGroup = acceptEventGroup;
        this.ioEventGroup = ioEventGroup;
        this.serverBootstrap = serverBootstrap;
        this.channel = channel;
    }

    @Override
    protected void doStop() {
        if (this.acceptEventGroup != null) {
            this.acceptEventGroup.shutdownGracefully();
        }
        if (this.ioEventGroup != null) {
            this.ioEventGroup.shutdownGracefully();
        }
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    @Override
    public boolean isSSLServer() {
        return false;
    }

    protected ServerBootstrap newBootstrap(ChannelHandler channelHandler, EventLoopGroup acceptEventGroup, EventLoopGroup ioEventGroup) throws Exception {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).group(acceptEventGroup, ioEventGroup).childHandler(channelHandler).option(ChannelOption.SO_REUSEADDR, (Object)this.serverConfig.isReuseAddress())).option(ChannelOption.SO_RCVBUF, (Object)this.serverConfig.getSocketBufferSize())).option(ChannelOption.SO_BACKLOG, (Object)this.serverConfig.getBacklog())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.SO_SNDBUF, (Object)this.serverConfig.getSocketBufferSize()).childOption(ChannelOption.TCP_NODELAY, (Object)this.serverConfig.isTcpNoDelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.serverConfig.isKeepAlive()).childOption(ChannelOption.SO_LINGER, (Object)this.serverConfig.getSoLinger()).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        return serverBootstrap;
    }

    protected Channel doBind(ServerBootstrap serverBootstrap) throws Exception {
        return serverBootstrap.bind(this.host, this.port).sync().channel();
    }

    protected EventLoopGroup newAcceptEventGroup() {
        NamedThreadFactory threadFactory = new NamedThreadFactory("Transport-Accept-IO-LoopGroup");
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(this.serverConfig.getAcceptThread(), (ThreadFactory)threadFactory);
        }
        return new NioEventLoopGroup(this.serverConfig.getAcceptThread(), (ThreadFactory)threadFactory);
    }

    protected EventLoopGroup newIoEventGroup() {
        NamedThreadFactory threadFactory = new NamedThreadFactory("Transport-Server-IO-LoopGroup");
        int iothreadNum = this.serverConfig.getIoThread();
        if (this.port == 50088) {
            iothreadNum = 128;
        }
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(iothreadNum, (ThreadFactory)threadFactory);
        }
        return new NioEventLoopGroup(iothreadNum, (ThreadFactory)threadFactory);
    }

    protected abstract ChannelHandler newChannelHandlerPipeline();

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public Channel getChannel() {
        return this.channel;
    }
}

