/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport.codec;

import io.journalkeeper.rpc.remoting.transport.codec.Codec;
import io.journalkeeper.rpc.remoting.transport.codec.Decoder;
import io.journalkeeper.rpc.remoting.transport.codec.PayloadCodecFactory;
import io.journalkeeper.rpc.remoting.transport.codec.PayloadDecoder;
import io.journalkeeper.rpc.remoting.transport.command.Command;
import io.journalkeeper.rpc.remoting.transport.command.Header;
import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecoder
implements Decoder {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultDecoder.class);
    private static final int LENGTH_FIELD_LENGTH = 4;
    private Codec headerCodec;
    private PayloadCodecFactory payloadCodecFactory;

    public DefaultDecoder(Codec headerCodec, PayloadCodecFactory payloadCodecFactory) {
        this.headerCodec = headerCodec;
        this.payloadCodecFactory = payloadCodecFactory;
    }

    @Override
    public Object decode(ByteBuf buffer) throws TransportException.CodecException {
        try {
            if (!buffer.isReadable(4)) {
                return null;
            }
            buffer.markReaderIndex();
            int length = this.readLength(buffer);
            if (buffer.readableBytes() < length) {
                buffer.resetReaderIndex();
                return null;
            }
            return this.doDecode(buffer);
        }
        catch (Exception e) {
            logger.error("decode exception", (Throwable)e);
            throw new TransportException.CodecException(e.getMessage());
        }
    }

    public Object doDecode(ByteBuf buffer) throws Exception {
        Header header = (Header)this.headerCodec.decode(buffer);
        if (header == null) {
            return null;
        }
        Object payload = null;
        if (header.getType() != -120) {
            PayloadDecoder decoder = this.payloadCodecFactory.getDecoder(header);
            if (decoder == null) {
                throw new TransportException.CodecException(String.format("unsupported decode payload type,header: %s", header));
            }
            payload = decoder.decode(header, buffer);
        }
        return new Command(header, payload);
    }

    protected int readLength(ByteBuf buffer) {
        return buffer.readInt() - 4;
    }
}

