/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport.command.handler.filter;

import io.journalkeeper.rpc.remoting.transport.Transport;
import io.journalkeeper.rpc.remoting.transport.command.Command;
import io.journalkeeper.rpc.remoting.transport.command.handler.CommandHandler;
import io.journalkeeper.rpc.remoting.transport.command.handler.filter.CommandHandlerContext;
import io.journalkeeper.rpc.remoting.transport.command.handler.filter.CommandHandlerFilter;
import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import java.util.Iterator;
import java.util.List;

public class CommandHandlerInvocation {
    private Transport transport;
    private Command command;
    private CommandHandler commandHandler;
    private Iterator<CommandHandlerFilter> filterIterator;
    private CommandHandlerContext context;

    public CommandHandlerInvocation(Transport transport, Command command, CommandHandler commandHandler, List<CommandHandlerFilter> filterList) {
        this.transport = transport;
        this.command = command;
        this.commandHandler = commandHandler;
        this.filterIterator = filterList == null || filterList.isEmpty() ? null : filterList.iterator();
    }

    public Command invoke() throws TransportException {
        if (this.filterIterator == null || !this.filterIterator.hasNext()) {
            return this.commandHandler.handle(this.transport, this.command);
        }
        return this.filterIterator.next().invoke(this);
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Command getCommand() {
        return this.command;
    }

    public CommandHandlerContext getContext() {
        if (this.context == null) {
            this.context = new CommandHandlerContext();
        }
        return this.context;
    }
}

