/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport.command.support;

import io.journalkeeper.rpc.remoting.transport.Transport;
import io.journalkeeper.rpc.remoting.transport.command.Command;
import io.journalkeeper.rpc.remoting.transport.command.handler.CommandHandler;
import io.journalkeeper.rpc.remoting.transport.command.handler.ExceptionHandler;
import io.journalkeeper.rpc.remoting.transport.command.handler.filter.CommandHandlerFilter;
import io.journalkeeper.rpc.remoting.transport.command.handler.filter.CommandHandlerFilterFactory;
import io.journalkeeper.rpc.remoting.transport.command.handler.filter.CommandHandlerInvocation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecuteTask
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(CommandExecuteTask.class);
    private Transport transport;
    private Command command;
    private CommandHandler commandHandler;
    private CommandHandlerFilterFactory commandHandlerFilterFactory;
    private ExceptionHandler exceptionHandler;

    public CommandExecuteTask(Transport transport, Command command, CommandHandler commandHandler, CommandHandlerFilterFactory commandHandlerFilterFactory, ExceptionHandler exceptionHandler) {
        this.transport = transport;
        this.command = command;
        this.commandHandler = commandHandler;
        this.commandHandlerFilterFactory = commandHandlerFilterFactory;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void run() {
        block3: {
            try {
                List<CommandHandlerFilter> commandHandlerFilters = this.commandHandlerFilterFactory.getFilters();
                CommandHandlerInvocation commandHandlerInvocation = new CommandHandlerInvocation(this.transport, this.command, this.commandHandler, commandHandlerFilters);
                Command response = commandHandlerInvocation.invoke();
                if (response != null) {
                    this.transport.acknowledge(this.command, response);
                }
            }
            catch (Throwable t) {
                logger.error("command handler exception, tratnsport: {}, command: {}", new Object[]{this.transport, this.command, t});
                if (this.exceptionHandler == null) break block3;
                this.exceptionHandler.handle(this.transport, this.command, t);
            }
        }
    }
}

