/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport.command.support;

import io.journalkeeper.rpc.remoting.transport.command.Command;
import io.journalkeeper.rpc.remoting.transport.command.Type;
import io.journalkeeper.rpc.remoting.transport.command.Types;
import io.journalkeeper.rpc.remoting.transport.command.handler.CommandHandler;
import io.journalkeeper.rpc.remoting.transport.command.handler.CommandHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandHandlerFactory
implements CommandHandlerFactory {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultCommandHandlerFactory.class);
    private Map<Integer, CommandHandler> commandHandlerMapper = new HashMap<Integer, CommandHandler>();

    @Override
    public CommandHandler getHandler(Command command) {
        int commandType = command.getHeader().getType();
        return this.commandHandlerMapper.get(commandType);
    }

    public void register(CommandHandler commandHandler) {
        if (commandHandler instanceof Types) {
            Types types = (Types)((Object)commandHandler);
            for (int type : types.types()) {
                this.register(type, commandHandler);
            }
        } else if (commandHandler instanceof Type) {
            this.register(((Type)((Object)commandHandler)).type(), commandHandler);
        } else {
            logger.warn("unsupported command type, commandHandler: {}", (Object)commandHandler);
        }
    }

    public void register(int type, CommandHandler commandHandler) {
        this.commandHandlerMapper.put(type, commandHandler);
    }
}

