/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport.command.support;

import io.journalkeeper.rpc.remoting.transport.Transport;
import io.journalkeeper.rpc.remoting.transport.command.Command;
import io.journalkeeper.rpc.remoting.transport.command.handler.CommandHandler;
import io.journalkeeper.rpc.remoting.transport.command.handler.CommandHandlerFactory;
import io.journalkeeper.rpc.remoting.transport.command.handler.ExceptionHandler;
import io.journalkeeper.rpc.remoting.transport.command.handler.filter.CommandHandlerFilterFactory;
import io.journalkeeper.rpc.remoting.transport.command.provider.ExecutorServiceProvider;
import io.journalkeeper.rpc.remoting.transport.command.support.CommandExecuteTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler {
    protected static final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private CommandHandlerFactory commandHandlerFactory;
    private CommandHandlerFilterFactory commandHandlerFilterFactory;
    private ExceptionHandler exceptionHandler;

    public RequestHandler(CommandHandlerFactory commandHandlerFactory, CommandHandlerFilterFactory commandHandlerFilterFactory, ExceptionHandler exceptionHandler) {
        this.commandHandlerFactory = commandHandlerFactory;
        this.commandHandlerFilterFactory = commandHandlerFilterFactory;
        this.exceptionHandler = exceptionHandler;
    }

    public void handle(Transport transport, Command command) {
        block5: {
            CommandHandler commandHandler = this.commandHandlerFactory.getHandler(command);
            if (commandHandler == null) {
                logger.error("unsupported command, command: {}", (Object)command);
                return;
            }
            CommandExecuteTask commandExecuteTask = new CommandExecuteTask(transport, command, commandHandler, this.commandHandlerFilterFactory, this.exceptionHandler);
            try {
                if (commandHandler instanceof ExecutorServiceProvider) {
                    ((ExecutorServiceProvider)((Object)commandHandler)).getExecutorService(transport, command).execute(commandExecuteTask);
                } else {
                    commandExecuteTask.run();
                }
            }
            catch (Throwable t) {
                logger.error("command handler exception, transport: {}, command: {}", new Object[]{transport, command, t});
                if (this.exceptionHandler == null) break block5;
                this.exceptionHandler.handle(transport, command, t);
            }
        }
    }
}

