/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport.command.support;

import io.journalkeeper.rpc.StatusCode;
import io.journalkeeper.rpc.remoting.transport.Transport;
import io.journalkeeper.rpc.remoting.transport.command.Command;
import io.journalkeeper.rpc.remoting.transport.command.handler.CommandHandler;
import io.journalkeeper.rpc.remoting.transport.command.handler.CommandHandlerFactory;
import io.journalkeeper.rpc.remoting.transport.command.support.DefaultCommandHandlerFactory;
import io.journalkeeper.rpc.utils.CommandSupport;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriRoutedCommandHandlerFactory
implements CommandHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(UriRoutedCommandHandlerFactory.class);
    private static final CommandHandler defaultHandler = new NoUriCommandHandler();
    private Map<URI, DefaultCommandHandlerFactory> handlerFactoryMap = new ConcurrentHashMap<URI, DefaultCommandHandlerFactory>();

    @Override
    public CommandHandler getHandler(Command command) {
        DefaultCommandHandlerFactory factory;
        URI destination = command.getHeader().getDestination();
        if (null != destination && null != (factory = this.handlerFactoryMap.get(destination))) {
            return factory.getHandler(command);
        }
        return defaultHandler;
    }

    public void register(URI destination, CommandHandler commandHandler) {
        DefaultCommandHandlerFactory factory = this.handlerFactoryMap.computeIfAbsent(destination, ignored -> new DefaultCommandHandlerFactory());
        factory.register(commandHandler);
    }

    public void unRegister(URI destination) {
        this.handlerFactoryMap.remove(destination);
    }

    private static class NoUriCommandHandler
    implements CommandHandler {
        private NoUriCommandHandler() {
        }

        @Override
        public Command handle(Transport transport, Command command) {
            return CommandSupport.newVoidPayloadResponse(StatusCode.SERVER_NOT_FOUND.getCode(), String.format("No server for uri: %s", command.getHeader().getDestination().toString()), command);
        }
    }
}

