/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport.support;

import io.journalkeeper.rpc.remoting.transport.ChannelTransport;
import io.journalkeeper.rpc.remoting.transport.IpUtil;
import io.journalkeeper.rpc.remoting.transport.RequestBarrier;
import io.journalkeeper.rpc.remoting.transport.ResponseFuture;
import io.journalkeeper.rpc.remoting.transport.TransportAttribute;
import io.journalkeeper.rpc.remoting.transport.TransportState;
import io.journalkeeper.rpc.remoting.transport.command.Command;
import io.journalkeeper.rpc.remoting.transport.command.CommandCallback;
import io.journalkeeper.rpc.remoting.transport.command.Direction;
import io.journalkeeper.rpc.remoting.transport.command.Header;
import io.journalkeeper.rpc.remoting.transport.command.Type;
import io.journalkeeper.rpc.remoting.transport.config.TransportConfig;
import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import io.journalkeeper.rpc.remoting.transport.support.DefaultTransportAttribute;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelTransport
implements ChannelTransport {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultChannelTransport.class);
    private Channel channel;
    private TransportAttribute attribute = new DefaultTransportAttribute();
    private RequestBarrier barrier;
    private TransportConfig config;
    private SocketAddress address;

    public DefaultChannelTransport(Channel channel, RequestBarrier barrier) {
        this.channel = channel;
        this.barrier = barrier;
        this.config = barrier.getConfig();
    }

    public DefaultChannelTransport(Channel channel, RequestBarrier barrier, SocketAddress address) {
        this.channel = channel;
        this.barrier = barrier;
        this.config = barrier.getConfig();
        this.address = address;
    }

    public DefaultChannelTransport(Channel channel, TransportAttribute attribute, RequestBarrier barrier, SocketAddress address) {
        this.channel = channel;
        this.attribute = attribute;
        this.barrier = barrier;
        this.config = barrier.getConfig();
        this.address = address;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public Command sync(Command command) throws TransportException {
        return this.sync(command, 0L);
    }

    @Override
    public Command sync(Command command, long timeout) throws TransportException {
        if (command == null) {
            throw new IllegalArgumentException("The argument command must not be null");
        }
        long sendTimeout = timeout <= 0L ? (long)this.barrier.getSendTimeout() : timeout;
        ResponseFuture future = new ResponseFuture(this, command, sendTimeout, null, null, new CountDownLatch(1));
        this.barrier.put(command.getHeader().getRequestId(), future);
        this.channel.writeAndFlush((Object)command).addListener((GenericFutureListener)new ResponseListener(future, this.barrier));
        try {
            Command response = future.await();
            if (null == response) {
                if (future.isSuccess()) {
                    throw TransportException.RequestTimeoutException.build(IpUtil.toAddress(this.address));
                }
                Throwable cause = future.getCause();
                if (cause != null) {
                    throw cause;
                }
                throw TransportException.RequestErrorException.build(IpUtil.toAddress(this.address));
            }
            return response;
        }
        catch (Throwable e) {
            future.release(e, false);
            this.barrier.remove(command.getHeader().getRequestId());
            if (e instanceof TransportException) {
                throw (TransportException)e;
            }
            if (e instanceof InterruptedException) {
                throw TransportException.InterruptedException.build();
            }
            throw TransportException.RequestErrorException.build("\u8bf7\u6c42\u9519\u8bef, " + this.address, e);
        }
    }

    @Override
    public void async(Command command, CommandCallback callback) throws TransportException {
        this.async(command, 0L, callback);
    }

    @Override
    public void async(Command command, long timeout, CommandCallback callback) throws TransportException {
        if (command == null) {
            throw new IllegalArgumentException("command must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        long sendTimeout = timeout <= 0L ? (long)this.barrier.getSendTimeout() : timeout;
        try {
            long time = System.currentTimeMillis();
            this.barrier.acquire(RequestBarrier.SemaphoreType.ASYNC, sendTimeout);
            time = System.currentTimeMillis() - time;
            sendTimeout = (int)(sendTimeout - time);
            sendTimeout = sendTimeout < 0L ? 0L : sendTimeout;
            ResponseFuture future = new ResponseFuture(this, command, sendTimeout, callback, this.barrier.asyncSemaphore, null);
            if (this.barrier.get(command.getHeader().getRequestId()) != null) {
                logger.warn("async command(type {}, request id {}) already exist", (Object)command.getHeader().getType(), (Object)command.getHeader().getRequestId());
            }
            this.barrier.put(command.getHeader().getRequestId(), future);
            this.channel.writeAndFlush((Object)command).addListener((GenericFutureListener)new ResponseListener(future, this.barrier));
        }
        catch (TransportException e) {
            this.barrier.release(RequestBarrier.SemaphoreType.ASYNC);
            command.release();
            throw e;
        }
    }

    @Override
    public Future<?> async(Command command) throws TransportException {
        return this.async(command);
    }

    @Override
    public Future<?> async(Command command, long timeout) throws TransportException {
        if (command == null) {
            throw new IllegalArgumentException("command must not be null");
        }
        long sendTimeout = timeout <= 0L ? (long)this.barrier.getSendTimeout() : timeout;
        try {
            long time = System.currentTimeMillis();
            this.barrier.acquire(RequestBarrier.SemaphoreType.ASYNC, sendTimeout);
            time = System.currentTimeMillis() - time;
            sendTimeout = (int)(sendTimeout - time);
            sendTimeout = sendTimeout < 0L ? 0L : sendTimeout;
            ResponseFuture future = new ResponseFuture(this, command, sendTimeout, null, this.barrier.asyncSemaphore, null);
            if (this.barrier.get(command.getHeader().getRequestId()) != null) {
                logger.warn("async command(type {}, request id {}) already exist", (Object)command.getHeader().getType(), (Object)command.getHeader().getRequestId());
            }
            this.barrier.put(command.getHeader().getRequestId(), future);
            this.channel.writeAndFlush((Object)command).addListener((GenericFutureListener)new ResponseListener(future, this.barrier));
            return future;
        }
        catch (TransportException e) {
            this.barrier.release(RequestBarrier.SemaphoreType.ASYNC);
            command.release();
            throw e;
        }
    }

    @Override
    public void oneway(Command command) throws TransportException {
        this.oneway(command, 0L);
    }

    @Override
    public void oneway(Command command, long timeout) throws TransportException {
        if (command == null) {
            throw new IllegalArgumentException("The argument command must not be null");
        }
        command.getHeader().setOneWay(true);
        ResponseFuture future = null;
        try {
            if (this.config.isNonBlockOneway()) {
                this.channel.writeAndFlush((Object)command);
                return;
            }
            long sendTimeout = timeout <= 0L ? (long)this.barrier.getSendTimeout() : timeout;
            long time = System.currentTimeMillis();
            this.barrier.acquire(RequestBarrier.SemaphoreType.ONEWAY, sendTimeout);
            time = System.currentTimeMillis() - time;
            sendTimeout = (int)(sendTimeout - time);
            sendTimeout = sendTimeout < 0L ? 0L : sendTimeout;
            future = new ResponseFuture(this, command, sendTimeout, null, this.barrier.onewaySemaphore, new CountDownLatch(1));
            this.channel.writeAndFlush((Object)command).addListener((GenericFutureListener)new OnewayListener(future));
            future.await();
            if (!future.isSuccess()) {
                Throwable cause = future.getCause();
                if (cause != null) {
                    if (cause instanceof TransportException) {
                        throw (TransportException)cause;
                    }
                    throw TransportException.RequestErrorException.build(cause);
                }
                throw TransportException.RequestErrorException.build();
            }
        }
        catch (TransportException e) {
            command.release();
            throw e;
        }
        catch (InterruptedException e) {
            TransportException.InterruptedException ex = TransportException.InterruptedException.build();
            if (future != null) {
                future.release(ex, false);
            }
            throw ex;
        }
    }

    @Override
    public void acknowledge(Command request, Command response) throws TransportException {
        this.acknowledge(request, response, null);
    }

    @Override
    public void acknowledge(Command request, Command response, CommandCallback callback) throws TransportException {
        Header header;
        if (response == null) {
            return;
        }
        if (request != null && (header = request.getHeader()) != null) {
            if (response.getHeader() == null) {
                response.setHeader(request.getHeader());
                response.getHeader().setDirection(Direction.RESPONSE);
            }
            if (response.getHeader().getDirection() == null) {
                response.getHeader().setDirection(Direction.RESPONSE);
            }
            if (response.getHeader().getType() == request.getHeader().getType() && response.getPayload() instanceof Type) {
                response.getHeader().setType(((Type)response.getPayload()).type());
            }
            response.getHeader().setRequestId(header.getRequestId());
            if (header.isOneWay()) {
                request.release();
                if (callback != null) {
                    try {
                        callback.onSuccess(request, response);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        this.channel.writeAndFlush((Object)response).addListener((GenericFutureListener)new CallbackListener(request, response, callback)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    @Override
    public SocketAddress remoteAddress() {
        if (this.address == null) {
            return this.channel.remoteAddress();
        }
        return this.address;
    }

    @Override
    public TransportAttribute attr() {
        return this.attribute;
    }

    @Override
    public void attr(TransportAttribute attribute) {
        this.attribute = attribute;
    }

    @Override
    public TransportState state() {
        if (this.channel.isActive()) {
            return TransportState.CONNECTED;
        }
        return TransportState.DISCONNECTED;
    }

    @Override
    public void stop() {
        this.channel.close();
    }

    public String toString() {
        return this.channel.toString();
    }

    protected static class CallbackListener
    implements ChannelFutureListener {
        private Command request;
        private Command response;
        private CommandCallback callback;

        public CallbackListener(Command request, Command response, CommandCallback callback) {
            this.request = request;
            this.response = response;
            this.callback = callback;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (this.callback != null) {
                if (future.isSuccess()) {
                    this.callback.onSuccess(this.request, this.response);
                } else {
                    this.callback.onException(this.request, null);
                }
            }
            this.request.release();
        }
    }

    protected static class OnewayListener
    extends FutureListener {
        public OnewayListener(ResponseFuture response) {
            super(response);
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            this.response.setSuccess(future.isSuccess());
            this.response.setCause(future.cause());
            this.response.setResponse(null);
            this.response.release(null, true);
            if (!this.response.isSuccess()) {
                Channel channel = future.channel();
                channel.close();
                this.logError(channel);
            }
        }
    }

    protected static class ResponseListener
    extends FutureListener {
        private RequestBarrier barrier;

        public ResponseListener(ResponseFuture response, RequestBarrier barrier) {
            super(response);
            this.barrier = barrier;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            this.response.setSuccess(future.isSuccess());
            if (this.response.isSuccess()) {
                Command request = this.response.getRequest();
                if (request != null) {
                    request.release();
                }
            } else {
                this.response.setCause(future.cause());
                this.response.setResponse(null);
                this.response.release(null, true);
                this.barrier.remove(this.response.getRequestId());
                Channel channel = future.channel();
                channel.close();
                this.logError(channel);
            }
        }
    }

    protected static abstract class FutureListener
    implements ChannelFutureListener {
        protected static final Logger logger = LoggerFactory.getLogger(FutureListener.class);
        protected ResponseFuture response;

        public FutureListener(ResponseFuture response) {
            this.response = response;
        }

        protected void logError(Channel channel) {
            String error = "send a request command to " + IpUtil.toAddress(channel.remoteAddress()) + " failed.";
            Throwable cause = this.response.getCause();
            if (cause != null) {
                if (!(cause instanceof ClosedChannelException)) {
                    logger.error(error, cause);
                }
            } else {
                logger.error(error);
            }
        }
    }
}

