/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport.support;

import io.journalkeeper.rpc.remoting.concurrent.EventBus;
import io.journalkeeper.rpc.remoting.concurrent.EventListener;
import io.journalkeeper.rpc.remoting.event.TransportEvent;
import io.journalkeeper.rpc.remoting.event.TransportEventHandler;
import io.journalkeeper.rpc.remoting.handler.ClientConnectionHandler;
import io.journalkeeper.rpc.remoting.transport.RequestBarrier;
import io.journalkeeper.rpc.remoting.transport.Transport;
import io.journalkeeper.rpc.remoting.transport.TransportClient;
import io.journalkeeper.rpc.remoting.transport.TransportClientSupport;
import io.journalkeeper.rpc.remoting.transport.codec.Codec;
import io.journalkeeper.rpc.remoting.transport.codec.support.NettyDecoder;
import io.journalkeeper.rpc.remoting.transport.codec.support.NettyEncoder;
import io.journalkeeper.rpc.remoting.transport.command.support.DefaultCommandDispatcher;
import io.journalkeeper.rpc.remoting.transport.command.support.RequestHandler;
import io.journalkeeper.rpc.remoting.transport.command.support.ResponseHandler;
import io.journalkeeper.rpc.remoting.transport.config.ClientConfig;
import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import io.journalkeeper.rpc.remoting.transport.handler.CommandInvocation;
import io.journalkeeper.rpc.remoting.transport.support.DefaultChannelTransport;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import java.net.SocketAddress;
import java.util.Timer;
import java.util.TimerTask;

public class DefaultTransportClient
extends TransportClientSupport
implements TransportClient {
    private Codec codec;
    private RequestBarrier requestBarrier;
    private RequestHandler requestHandler;
    private ResponseHandler responseHandler;
    private EventBus<TransportEvent> transportEventBus;
    private Timer clearTimer;

    public DefaultTransportClient(ClientConfig config, Codec codec, RequestBarrier requestBarrier, RequestHandler requestHandler, ResponseHandler responseHandler, EventBus<TransportEvent> transportEventBus) {
        super(config);
        this.codec = codec;
        this.requestBarrier = requestBarrier;
        this.requestHandler = requestHandler;
        this.responseHandler = responseHandler;
        this.transportEventBus = transportEventBus;
        this.clearTimer = new Timer("DefaultTransportClient-Clear-Timer");
    }

    @Override
    protected ChannelHandler newChannelHandlerPipeline() {
        final DefaultCommandDispatcher commandDispatcher = new DefaultCommandDispatcher(this.requestBarrier, this.requestHandler, this.responseHandler);
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{new NettyDecoder(DefaultTransportClient.this.codec)}).addLast(new ChannelHandler[]{new NettyEncoder(DefaultTransportClient.this.codec)}).addLast(new ChannelHandler[]{new ClientConnectionHandler()}).addLast(new ChannelHandler[]{new TransportEventHandler(DefaultTransportClient.this.requestBarrier, DefaultTransportClient.this.transportEventBus)}).addLast(new ChannelHandler[]{new CommandInvocation(commandDispatcher)});
            }
        };
    }

    @Override
    public Transport createTransport(String address) throws TransportException {
        return this.createTransport(address, -1L);
    }

    @Override
    public Transport createTransport(String address, long connectionTimeout) throws TransportException {
        return this.createTransport(DefaultTransportClient.createInetSocketAddress(address), connectionTimeout);
    }

    @Override
    public Transport createTransport(SocketAddress address) throws TransportException {
        return this.createTransport(address, -1L);
    }

    @Override
    public Transport createTransport(SocketAddress address, long connectionTimeout) throws TransportException {
        Channel channel = this.createChannel(address, connectionTimeout);
        return new DefaultChannelTransport(channel, this.requestBarrier, address);
    }

    @Override
    public void addListener(EventListener<TransportEvent> listener) {
        this.transportEventBus.addListener(listener);
    }

    @Override
    public void removeListener(EventListener<TransportEvent> listener) {
        this.transportEventBus.removeListener(listener);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.clearTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                DefaultTransportClient.this.requestBarrier.evict();
            }
        }, this.getConfig().getSendTimeout(), (long)this.getConfig().getSendTimeout());
        this.transportEventBus.start();
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.clearTimer.cancel();
        this.transportEventBus.stop(false);
        this.requestBarrier.clear();
        this.responseHandler.stop();
    }
}

