/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport.support;

import io.journalkeeper.rpc.handler.ExceptionChannelHandler;
import io.journalkeeper.rpc.remoting.concurrent.EventBus;
import io.journalkeeper.rpc.remoting.event.TransportEvent;
import io.journalkeeper.rpc.remoting.event.TransportEventHandler;
import io.journalkeeper.rpc.remoting.transport.RequestBarrier;
import io.journalkeeper.rpc.remoting.transport.TransportServerSupport;
import io.journalkeeper.rpc.remoting.transport.codec.Codec;
import io.journalkeeper.rpc.remoting.transport.codec.support.NettyDecoder;
import io.journalkeeper.rpc.remoting.transport.codec.support.NettyEncoder;
import io.journalkeeper.rpc.remoting.transport.command.handler.ExceptionHandler;
import io.journalkeeper.rpc.remoting.transport.command.support.DefaultCommandDispatcher;
import io.journalkeeper.rpc.remoting.transport.command.support.RequestHandler;
import io.journalkeeper.rpc.remoting.transport.command.support.ResponseHandler;
import io.journalkeeper.rpc.remoting.transport.config.ServerConfig;
import io.journalkeeper.rpc.remoting.transport.handler.CommandInvocation;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;

public class DefaultTransportServer
extends TransportServerSupport {
    private Codec codec;
    private ExceptionHandler exceptionHandler;
    private RequestBarrier requestBarrier;
    private RequestHandler requestHandler;
    private ResponseHandler responseHandler;
    private EventBus<TransportEvent> transportEventBus;

    public DefaultTransportServer(ServerConfig serverConfig, String host, int port, Codec codec, ExceptionHandler exceptionHandler, RequestBarrier requestBarrier, RequestHandler requestHandler, ResponseHandler responseHandler, EventBus<TransportEvent> transportEventBus) {
        super(serverConfig, host, port);
        this.codec = codec;
        this.exceptionHandler = exceptionHandler;
        this.requestBarrier = requestBarrier;
        this.requestHandler = requestHandler;
        this.responseHandler = responseHandler;
        this.transportEventBus = transportEventBus;
    }

    @Override
    protected ChannelHandler newChannelHandlerPipeline() {
        final DefaultCommandDispatcher commandDispatcher = new DefaultCommandDispatcher(this.requestBarrier, this.requestHandler, this.responseHandler);
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{new NettyDecoder(DefaultTransportServer.this.codec)}).addLast(new ChannelHandler[]{new NettyEncoder(DefaultTransportServer.this.codec)}).addLast(new ChannelHandler[]{new TransportEventHandler(DefaultTransportServer.this.requestBarrier, DefaultTransportServer.this.transportEventBus)}).addLast(new ChannelHandler[]{new ExceptionChannelHandler(DefaultTransportServer.this.exceptionHandler, DefaultTransportServer.this.requestBarrier)}).addLast(new ChannelHandler[]{new CommandInvocation(commandDispatcher)});
            }
        };
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.transportEventBus.start();
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.responseHandler.stop();
        this.transportEventBus.stop(false);
        this.requestBarrier.clear();
    }
}

