/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.remoting.transport.support;

import io.journalkeeper.rpc.remoting.concurrent.EventBus;
import io.journalkeeper.rpc.remoting.event.TransportEvent;
import io.journalkeeper.rpc.remoting.event.TransportEventType;
import io.journalkeeper.rpc.remoting.retry.RetryPolicy;
import io.journalkeeper.rpc.remoting.transport.ChannelTransport;
import io.journalkeeper.rpc.remoting.transport.IpUtil;
import io.journalkeeper.rpc.remoting.transport.TransportAttribute;
import io.journalkeeper.rpc.remoting.transport.TransportClient;
import io.journalkeeper.rpc.remoting.transport.TransportState;
import io.journalkeeper.rpc.remoting.transport.command.Command;
import io.journalkeeper.rpc.remoting.transport.command.CommandCallback;
import io.journalkeeper.rpc.remoting.transport.config.TransportConfig;
import io.journalkeeper.rpc.remoting.transport.exception.TransportException;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverChannelTransport
implements ChannelTransport {
    protected static final Logger logger = LoggerFactory.getLogger(FailoverChannelTransport.class);
    private volatile ChannelTransport delegate;
    private SocketAddress address;
    private long connectionTimeout;
    private TransportClient transportClient;
    private TransportConfig config;
    private EventBus<TransportEvent> transportEventBus;
    private volatile long lastReconnect;

    public FailoverChannelTransport(ChannelTransport delegate, SocketAddress address, long connectionTimeout, TransportClient transportClient, TransportConfig config, EventBus<TransportEvent> transportEventBus) {
        this.delegate = delegate;
        this.address = address;
        this.connectionTimeout = connectionTimeout;
        this.transportClient = transportClient;
        this.config = config;
        this.transportEventBus = transportEventBus;
    }

    @Override
    public Channel getChannel() {
        return this.delegate.getChannel();
    }

    @Override
    public Command sync(Command command) throws TransportException {
        return this.sync(command, 0L);
    }

    @Override
    public Command sync(Command command, long timeout) throws TransportException {
        RetryPolicy retryPolicy = this.config.getRetryPolicy();
        TransportException lastException = null;
        Command response = null;
        int retryTimes = 0;
        int retryLimit = retryPolicy.getMaxRetrys();
        for (int i = 0; i <= retryLimit; ++i) {
            try {
                response = this.delegate.sync(command, timeout);
                break;
            }
            catch (TransportException e) {
                if (!(e instanceof TransportException.RequestTimeoutException) && !this.tryReconnect()) {
                    throw e;
                }
                lastException = e;
                ++retryTimes;
                continue;
            }
        }
        if (lastException != null && response == null) {
            throw lastException;
        }
        if (lastException != null) {
            logger.warn("transport sync exception, retry {} times success, command: {}, timeout: {}", new Object[]{retryTimes, command, timeout, lastException});
        }
        return response;
    }

    @Override
    public void async(Command command, CommandCallback callback) throws TransportException {
        this.async(command, 0L, callback);
    }

    @Override
    public void async(Command command, long timeout, CommandCallback callback) throws TransportException {
        if (command == null) {
            throw new IllegalArgumentException("command must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        if (!this.checkChannel()) {
            callback.onException(command, TransportException.RequestErrorException.build(IpUtil.toAddress(this.delegate.getChannel().remoteAddress())));
            return;
        }
        this.delegate.async(command, timeout, callback);
    }

    @Override
    public Future<?> async(Command command) throws TransportException {
        return this.delegate.async(command);
    }

    @Override
    public Future<?> async(Command command, long timeout) throws TransportException {
        return this.delegate.async(command, timeout);
    }

    @Override
    public void oneway(Command command) throws TransportException {
        this.oneway(command, 0L);
    }

    @Override
    public void oneway(Command command, long timeout) throws TransportException {
        this.delegate.oneway(command, timeout);
    }

    @Override
    public void acknowledge(Command request, Command response) throws TransportException {
        this.delegate.acknowledge(request, response);
    }

    @Override
    public void acknowledge(Command request, Command response, CommandCallback callback) throws TransportException {
        this.delegate.acknowledge(request, response, callback);
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.delegate.remoteAddress();
    }

    @Override
    public TransportAttribute attr() {
        return this.delegate.attr();
    }

    @Override
    public void attr(TransportAttribute attribute) {
        this.delegate.attr(attribute);
    }

    @Override
    public TransportState state() {
        return this.delegate.state();
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    public String toString() {
        return this.delegate.toString();
    }

    protected boolean checkChannel() {
        if (this.isChannelActive()) {
            return true;
        }
        return this.tryReconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryReconnect() {
        if (!this.isNeedReconnect()) {
            return false;
        }
        FailoverChannelTransport failoverChannelTransport = this;
        synchronized (failoverChannelTransport) {
            if (this.isNeedReconnect()) {
                return this.reconnect();
            }
            return false;
        }
    }

    protected boolean isChannelActive() {
        return this.delegate.getChannel().isActive();
    }

    protected boolean isNeedReconnect() {
        return System.currentTimeMillis() - this.lastReconnect > (long)this.config.getRetryPolicy().getRetryDelay().intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reconnect() {
        try {
            ChannelTransport newTransport = (ChannelTransport)this.transportClient.createTransport(this.address, this.connectionTimeout);
            ChannelTransport delegate = this.delegate;
            this.delegate = newTransport;
            try {
                delegate.stop();
            }
            catch (Throwable t) {
                logger.warn("stop transport exception, transport: {}", (Object)newTransport, (Object)t);
            }
            logger.info("reconnect transport success, transport: {}", (Object)newTransport);
            this.transportEventBus.add(new TransportEvent(TransportEventType.RECONNECT, newTransport));
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            logger.debug("reconnect transport exception, address: {}", (Object)this.address, (Object)t);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lastReconnect = System.currentTimeMillis();
        }
    }
}

