/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.server;

import io.journalkeeper.rpc.RpcException;
import io.journalkeeper.rpc.UriSupport;
import io.journalkeeper.rpc.client.ClientServerRpcStub;
import io.journalkeeper.rpc.remoting.transport.TransportClient;
import io.journalkeeper.rpc.server.ServerRpc;
import io.journalkeeper.rpc.server.ServerRpcAccessPoint;
import io.journalkeeper.rpc.server.ServerRpcStub;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JournalKeeperServerRpcAccessPoint
implements ServerRpcAccessPoint {
    private final Properties properties;
    private final TransportClient transportClient;
    private Map<URI, ServerRpcStub> serverInstances = new HashMap<URI, ServerRpcStub>();
    public final String PROTOCOL_VERSION_KEY = "protocol.version";
    private final int protocolVersion;

    public JournalKeeperServerRpcAccessPoint(TransportClient transportClient, Properties properties) {
        this.transportClient = transportClient;
        try {
            transportClient.start();
        }
        catch (Exception e) {
            throw new RpcException((Throwable)e);
        }
        this.properties = properties;
        this.protocolVersion = Integer.parseInt(properties.getProperty("protocol.version", String.valueOf(2)));
    }

    private ServerRpcStub createServerRpc(URI server) {
        return new ServerRpcStub(this.transportClient, server, UriSupport.parseUri((URI)server), this.protocolVersion);
    }

    public ServerRpc getServerRpcAgent(URI uri) {
        if (null == uri) {
            return null;
        }
        return this.serverInstances.computeIfAbsent(uri, this::createServerRpc);
    }

    public void stop() {
        this.serverInstances.values().forEach(ClientServerRpcStub::stop);
        this.transportClient.stop();
    }
}

