/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.rpc.utils;

import io.journalkeeper.exceptions.ServerNotFoundException;
import io.journalkeeper.rpc.BaseResponse;
import io.journalkeeper.rpc.RpcException;
import io.journalkeeper.rpc.StatusCode;
import io.journalkeeper.rpc.header.JournalKeeperHeader;
import io.journalkeeper.rpc.payload.GenericPayload;
import io.journalkeeper.rpc.payload.VoidPayload;
import io.journalkeeper.rpc.remoting.transport.Transport;
import io.journalkeeper.rpc.remoting.transport.command.Command;
import io.journalkeeper.rpc.remoting.transport.command.CommandCallback;
import io.journalkeeper.rpc.remoting.transport.command.Direction;
import io.journalkeeper.rpc.remoting.transport.command.Header;
import java.net.URI;
import java.util.concurrent.CompletableFuture;

public class CommandSupport {
    private static <T> Command newRequestCommand(int type, T request, URI destination, int version) {
        JournalKeeperHeader header = new JournalKeeperHeader(version, Direction.REQUEST, type, destination);
        return new Command(header, new GenericPayload<T>(request));
    }

    private static Command newRequestCommand(int type, URI destination, int version) {
        JournalKeeperHeader header = new JournalKeeperHeader(version, Direction.REQUEST, type, destination);
        return new Command(header, new VoidPayload());
    }

    public static <Q, R extends BaseResponse> CompletableFuture<R> sendRequest(Q request, int requestType, Transport transport, URI destination, int version) {
        final CompletableFuture future = new CompletableFuture();
        transport.async(null == request ? CommandSupport.newRequestCommand(requestType, destination, version) : CommandSupport.newRequestCommand(requestType, request, destination, version), new CommandCallback(){

            @Override
            public void onSuccess(Command request, Command response) {
                if (response.getHeader().getType() == -120) {
                    if (response.getHeader().getStatus() == StatusCode.SERVER_NOT_FOUND.getCode()) {
                        future.completeExceptionally((Throwable)new ServerNotFoundException(response.getHeader().getError()));
                    } else {
                        future.completeExceptionally((Throwable)new RpcException(String.format("StatusCode: (%d)%s, ErrorMessage: %s", response.getHeader().getStatus(), StatusCode.valueOf((int)response.getHeader().getStatus()).getMessage(new Object[0]), response.getHeader().getError())));
                    }
                } else {
                    future.complete(GenericPayload.get(response.getPayload()));
                }
            }

            @Override
            public void onException(Command request, Throwable cause) {
                future.completeExceptionally(cause);
            }
        });
        return future;
    }

    public static void sendResponse(BaseResponse response, int responseType, Command requestCommand, Transport transport) {
        Command responseCommand = CommandSupport.newResponseCommand(response, responseType, requestCommand);
        transport.acknowledge(requestCommand, responseCommand);
    }

    public static Command newResponseCommand(BaseResponse response, int responseType, Command requestCommand) {
        Header requestHeader = requestCommand.getHeader();
        JournalKeeperHeader header = new JournalKeeperHeader(requestHeader.getVersion(), Direction.RESPONSE, requestHeader.getRequestId(), responseType, null);
        header.setStatus(response.getStatusCode().getCode());
        header.setError(response.getError());
        return new Command(header, new GenericPayload<BaseResponse>(response));
    }

    public static Command newVoidPayloadResponse(int status, String error, Command requestCommand) {
        Header requestHeader = requestCommand.getHeader();
        JournalKeeperHeader header = new JournalKeeperHeader(requestHeader.getVersion(), Direction.RESPONSE, requestHeader.getRequestId(), -120, null);
        header.setStatus(status);
        header.setError(error);
        return new Command(header, new VoidPayload());
    }
}

