/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker;

import org.joyqueue.broker.BannerPrinter;
import org.joyqueue.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    protected static final Logger logger = LoggerFactory.getLogger(Launcher.class);

    public static void main(String[] args) {
        BrokerService brokerService = new BrokerService(args);
        try {
            brokerService.start();
            BannerPrinter.print();
            logger.info("JoyQueue is started");
        }
        catch (Throwable t) {
            logger.error("JoyQueue start exception", t);
            brokerService.stop();
            System.exit(-1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                brokerService.stop();
                logger.info("JoyQueue stopped");
            }
            catch (Throwable t) {
                logger.error("JoyQueue stop exception", t);
                System.exit(-1);
            }
        }));
    }
}

