/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.tools;

import com.beust.jcommander.JCommander;
import io.openmessaging.KeyValue;
import io.openmessaging.MessagingAccessPoint;
import io.openmessaging.OMS;
import io.openmessaging.consumer.Consumer;
import io.openmessaging.consumer.MessageListener;
import io.openmessaging.extension.ExtensionHeader;
import io.openmessaging.message.Header;
import io.openmessaging.message.Message;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joyqueue.tools.config.ConsoleConsumerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleConsumer {
    protected static Logger logger = LoggerFactory.getLogger(ConsoleConsumer.class);

    public static void main(String[] args) {
        ConsoleConsumerConfig config = new ConsoleConsumerConfig();
        JCommander jcommander = JCommander.newBuilder().addObject((Object)config).build();
        jcommander.parse(args);
        if (config.isHelp()) {
            jcommander.usage();
            return;
        }
        Consumer consumer = ConsoleConsumer.buildConsumer(config);
        consumer.start();
        ConsoleConsumer.run(consumer, config);
    }

    protected static Consumer buildConsumer(ConsoleConsumerConfig config) {
        KeyValue keyValue = OMS.newKeyValue();
        keyValue.put("ACCOUNT_KEY", config.getToken());
        keyValue.put("NAMESERVER_NAMESPACE", StringUtils.defaultIfBlank((String)config.getNamespace(), (String)""));
        for (Map.Entry<String, String> entry : config.getParams().entrySet()) {
            keyValue.put(entry.getKey(), entry.getValue());
        }
        MessagingAccessPoint messagingAccessPoint = OMS.getMessagingAccessPoint((String)String.format("oms:%s://%s@%s/%s", "joyqueue", config.getApp(), config.getBootstrap(), StringUtils.defaultIfBlank((String)config.getRegion(), (String)"UNKNOWN")), (KeyValue)keyValue);
        return messagingAccessPoint.createConsumer();
    }

    protected static void run(Consumer consumer, ConsoleConsumerConfig config) {
        consumer.bindQueue(config.getTopic(), new MessageListener(){

            public void onReceived(Message message, MessageListener.Context context) {
                Header header = message.header();
                ExtensionHeader extensionHeader = (ExtensionHeader)message.extensionHeader().get();
                logger.info("Message{topic: {}, partition: {}, index: {}, txId: {}, key: {}, body: {}}", new Object[]{header.getDestination(), extensionHeader.getPartiton(), extensionHeader.getOffset(), extensionHeader.getTransactionId(), extensionHeader.getMessageKey(), new String(message.getData())});
            }
        });
    }
}

