/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.tools;

import com.beust.jcommander.JCommander;
import io.openmessaging.KeyValue;
import io.openmessaging.MessagingAccessPoint;
import io.openmessaging.OMS;
import io.openmessaging.extension.ExtensionHeader;
import io.openmessaging.message.Message;
import io.openmessaging.producer.Producer;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joyqueue.tools.config.ConsoleProducerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleProducer {
    protected static Logger logger = LoggerFactory.getLogger(ConsoleProducer.class);

    public static void main(String[] args) {
        ConsoleProducerConfig config = new ConsoleProducerConfig();
        JCommander jcommander = JCommander.newBuilder().addObject((Object)config).build();
        jcommander.parse(args);
        if (config.isHelp()) {
            jcommander.usage();
            return;
        }
        Producer producer = ConsoleProducer.buildProducer(config);
        producer.start();
        ConsoleProducer.send(producer, config);
        System.exit(0);
    }

    protected static Producer buildProducer(ConsoleProducerConfig config) {
        KeyValue keyValue = OMS.newKeyValue();
        keyValue.put("ACCOUNT_KEY", config.getToken());
        keyValue.put("NAMESERVER_NAMESPACE", StringUtils.defaultIfBlank((String)config.getNamespace(), (String)""));
        for (Map.Entry<String, String> entry : config.getParams().entrySet()) {
            keyValue.put(entry.getKey(), entry.getValue());
        }
        MessagingAccessPoint messagingAccessPoint = OMS.getMessagingAccessPoint((String)String.format("oms:%s://%s@%s/%s", "joyqueue", config.getApp(), config.getBootstrap(), StringUtils.defaultIfBlank((String)config.getRegion(), (String)"UNKNOWN")), (KeyValue)keyValue);
        return messagingAccessPoint.createProducer();
    }

    protected static void send(Producer producer, ConsoleProducerConfig config) {
        Message message = producer.createMessage(config.getTopic(), StringUtils.defaultString((String)config.getBody(), (String)"message body").getBytes());
        if (StringUtils.isNotBlank((String)config.getKey())) {
            ((ExtensionHeader)message.extensionHeader().get()).setMessageKey(config.getKey());
        }
        producer.send(message);
        producer.stop();
    }
}

