/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.api;

import io.journalkeeper.core.api.JournalEntry;
import io.journalkeeper.core.api.ResponseConfig;
import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.utils.event.Watchable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface PartitionedJournalStore
extends Watchable {
    default public CompletableFuture<Long> append(int partition, int batchSize, byte[] entries) {
        return this.append(partition, batchSize, entries, ResponseConfig.REPLICATION);
    }

    default public CompletableFuture<Long> append(int partition, int batchSize, byte[] entries, ResponseConfig responseConfig) {
        return this.append(partition, batchSize, entries, false, responseConfig);
    }

    default public CompletableFuture<Long> append(int partition, int batchSize, byte[] entries, boolean includeHeader, ResponseConfig responseConfig) {
        return this.append(new UpdateRequest(entries, partition, batchSize), includeHeader, responseConfig);
    }

    default public CompletableFuture<Long> append(UpdateRequest updateRequest) {
        return this.append(updateRequest, ResponseConfig.REPLICATION);
    }

    default public CompletableFuture<Long> append(UpdateRequest updateRequest, ResponseConfig responseConfig) {
        return this.append(updateRequest, false, responseConfig);
    }

    public CompletableFuture<Long> append(UpdateRequest var1, boolean var2, ResponseConfig var3);

    default public CompletableFuture<List<Long>> append(List<UpdateRequest> updateRequests) {
        return this.append(updateRequests, ResponseConfig.REPLICATION);
    }

    default public CompletableFuture<List<Long>> append(List<UpdateRequest> updateRequests, ResponseConfig responseConfig) {
        return this.append(updateRequests, false, responseConfig);
    }

    public CompletableFuture<List<Long>> append(List<UpdateRequest> var1, boolean var2, ResponseConfig var3);

    public CompletableFuture<List<JournalEntry>> get(int var1, long var2, int var4);

    public CompletableFuture<Map<Integer, Long>> minIndices();

    public CompletableFuture<Map<Integer, Long>> maxIndices();

    public CompletableFuture<Set<Integer>> listPartitions();

    public CompletableFuture<Long> queryIndex(int var1, long var2);
}

