/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.api;

import io.journalkeeper.core.api.ClusterReadyAware;
import io.journalkeeper.core.api.QueryConsistency;
import io.journalkeeper.core.api.ResponseConfig;
import io.journalkeeper.core.api.ServerConfigAware;
import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.core.api.transaction.TransactionClient;
import io.journalkeeper.utils.event.Watchable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface RaftClient
extends Watchable,
ClusterReadyAware,
ServerConfigAware,
TransactionClient {
    default public CompletableFuture<byte[]> update(byte[] entry) {
        return this.update(entry, 0, 1, false, ResponseConfig.REPLICATION);
    }

    default public CompletableFuture<byte[]> update(byte[] entry, int partition, int batchSize, ResponseConfig responseConfig) {
        return this.update(entry, partition, batchSize, false, responseConfig);
    }

    default public CompletableFuture<byte[]> update(byte[] entry, int partition, int batchSize, boolean includeHeader, ResponseConfig responseConfig) {
        return this.update(new UpdateRequest(entry, partition, batchSize), includeHeader, responseConfig);
    }

    default public CompletableFuture<byte[]> update(UpdateRequest updateRequest, boolean includeHeader, ResponseConfig responseConfig) {
        return this.update(Collections.singletonList(updateRequest), includeHeader, responseConfig).thenApply(ers -> {
            if (null != ers && ers.size() > 0) {
                return (byte[])ers.get(0);
            }
            return null;
        });
    }

    default public CompletableFuture<byte[]> update(UpdateRequest updateRequest, ResponseConfig responseConfig) {
        return this.update(updateRequest, false, responseConfig);
    }

    default public CompletableFuture<byte[]> update(UpdateRequest updateRequest) {
        return this.update(updateRequest, false, ResponseConfig.REPLICATION);
    }

    default public CompletableFuture<List<byte[]>> update(List<UpdateRequest> updateRequests, ResponseConfig responseConfig) {
        return this.update(updateRequests, false, responseConfig);
    }

    default public CompletableFuture<List<byte[]>> update(List<UpdateRequest> updateRequests) {
        return this.update(updateRequests, false, ResponseConfig.REPLICATION);
    }

    public CompletableFuture<List<byte[]>> update(List<UpdateRequest> var1, boolean var2, ResponseConfig var3);

    default public CompletableFuture<byte[]> query(byte[] query) {
        return this.query(query, QueryConsistency.STRICT);
    }

    public CompletableFuture<byte[]> query(byte[] var1, QueryConsistency var2);

    public void stop();
}

