/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.api.transaction;

import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.core.api.transaction.TransactionContext;
import io.journalkeeper.core.api.transaction.TransactionId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface TransactionalJournalStore {
    default public CompletableFuture<TransactionContext> createTransaction() {
        return this.createTransaction(Collections.emptyMap());
    }

    public CompletableFuture<TransactionContext> createTransaction(Map<String, String> var1);

    public CompletableFuture<Void> completeTransaction(TransactionId var1, boolean var2);

    public CompletableFuture<Collection<TransactionContext>> getOpeningTransactions();

    default public CompletableFuture<Void> append(TransactionId transactionId, byte[] entry) {
        return this.append(transactionId, entry, 0, 1, false);
    }

    default public CompletableFuture<Void> append(TransactionId transactionId, byte[] entry, int partition, int batchSize) {
        return this.append(transactionId, entry, partition, batchSize, false);
    }

    default public CompletableFuture<Void> append(TransactionId transactionId, byte[] entry, int partition, int batchSize, boolean includeHeader) {
        return this.append(transactionId, new UpdateRequest(entry, partition, batchSize), includeHeader);
    }

    public CompletableFuture<Void> append(TransactionId var1, UpdateRequest var2, boolean var3);

    default public CompletableFuture<Void> append(TransactionId transactionId, UpdateRequest updateRequest) {
        return this.append(transactionId, updateRequest, false);
    }

    default public CompletableFuture<Void> append(TransactionId transactionId, List<UpdateRequest> updateRequests) {
        return this.append(transactionId, updateRequests, false);
    }

    public CompletableFuture<Void> append(TransactionId var1, List<UpdateRequest> var2, boolean var3);
}

