/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.cluster;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.mqtt.connection.MqttConnection;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttConnectionManager
extends Service {
    private static final Logger LOG = LoggerFactory.getLogger(MqttConnectionManager.class);
    private final ConcurrentMap<String, MqttConnection> connections = new ConcurrentHashMap<String, MqttConnection>();

    public MqttConnection addConnection(MqttConnection connection) {
        return this.connections.putIfAbsent(connection.getClientId(), connection);
    }

    public boolean removeConnection(MqttConnection connection) {
        return this.connections.remove(connection.getClientId(), (Object)connection);
    }

    public Optional<MqttConnection> lookupConnection(String clientID) {
        if (clientID == null) {
            return Optional.empty();
        }
        MqttConnection connection = (MqttConnection)((Object)this.connections.get(clientID));
        if (connection == null) {
            return Optional.empty();
        }
        return Optional.of(connection);
    }

    public MqttConnection getConnection(String clientID) {
        MqttConnection connection = null;
        if (Strings.isNullOrEmpty((String)clientID)) {
            LOG.error("ClientID is null or empty for find connection, aborting...");
        } else {
            connection = (MqttConnection)((Object)this.connections.get(clientID));
            if (connection == null) {
                LOG.error("Can't find the connection for client: <{}>", (Object)clientID);
                throw new RuntimeException("Can't find the connection for client <" + clientID + ">");
            }
        }
        return connection;
    }

    public boolean isConnected(String clientID) {
        return this.connections.containsKey(clientID);
    }

    public int countConnections() {
        return this.connections.size();
    }

    public Collection<String> getConnectionIds() {
        return this.connections.keySet();
    }

    public ConcurrentMap<String, MqttConnection> listConnections() {
        return this.connections;
    }

    public int connectionsTotal() {
        return this.connections.size();
    }
}

