/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.mqtt.cluster;

import com.google.common.base.Strings;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.mqtt.cluster.MqttConnectionManager;
import org.joyqueue.broker.mqtt.cluster.MqttSessionManager;
import org.joyqueue.broker.mqtt.connection.MqttConnection;
import org.joyqueue.broker.mqtt.publish.MessagePublisher;
import org.joyqueue.broker.mqtt.session.MqttSession;
import org.joyqueue.broker.mqtt.subscriptions.MqttSubscription;
import org.joyqueue.broker.mqtt.util.PollSelector;
import org.joyqueue.broker.mqtt.util.Selector;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttConsumerManager
extends Service {
    private static final Logger LOG = LoggerFactory.getLogger(MqttConsumerManager.class);
    private static int CONSUME_THREAD_TOTAL = 10;
    private static int ASYNC_PUB_THREAD_TOTAL = 100;
    private static int ASYNC_ACK_THREAD_TOTAL = 50;
    private Selector selector = new PollSelector();
    private ExecutorService executorService;
    private ExecutorService asyncPublishExecutorService;
    private ExecutorService asyncAcknowledgeExecutorService;
    private ConcurrentMap<Integer, Runnable> consumeThreadMap = new ConcurrentHashMap<Integer, Runnable>();
    private ConcurrentMap<String, Runnable> clientConsumeThreadMap = new ConcurrentHashMap<String, Runnable>();
    private ConcurrentMap<String, Consumer> consumers = new ConcurrentHashMap<String, Consumer>();
    private Consume consume;
    private MqttConnectionManager connectionManager;
    private MqttSessionManager sessionManager;
    private MessagePublisher messagePublisher;

    public MqttConsumerManager(BrokerContext brokerContext, MqttConnectionManager connectionManager, MqttSessionManager sessionManager, MessagePublisher messagePublisher) {
        this.consume = brokerContext.getConsume();
        this.connectionManager = connectionManager;
        this.sessionManager = sessionManager;
        this.messagePublisher = messagePublisher;
    }

    protected void validate() throws Exception {
        super.validate();
        this.executorService = Executors.newFixedThreadPool(CONSUME_THREAD_TOTAL, (ThreadFactory)new NamedThreadFactory("mqtt-consume"));
        this.asyncPublishExecutorService = Executors.newFixedThreadPool(ASYNC_PUB_THREAD_TOTAL, (ThreadFactory)new NamedThreadFactory("mqtt-async-publish"));
        this.asyncAcknowledgeExecutorService = Executors.newFixedThreadPool(ASYNC_ACK_THREAD_TOTAL, (ThreadFactory)new NamedThreadFactory("mqtt-async-acknowledge"));
    }

    public void start() throws Exception {
        super.start();
        for (int i = 0; i < CONSUME_THREAD_TOTAL; ++i) {
            ConsumeTask consumeTask = new ConsumeTask(Integer.toString(i));
            this.consumeThreadMap.put(i, consumeTask);
            this.executorService.execute(consumeTask);
        }
    }

    public void stop() {
        super.stop();
        if (!this.executorService.isShutdown()) {
            this.clientConsumeThreadMap.forEach((clientID, consumeThread) -> {
                if (consumeThread != null) {
                    ConsumeTask consumeTask = (ConsumeTask)consumeThread;
                    consumeTask.setRunning(false);
                }
            });
            this.executorService.shutdownNow();
        }
    }

    public void fireConsume(String clientID) {
        MqttSession session = this.sessionManager.getSession(clientID);
        ConsumeTask consumeTask = this.selectThreadConsume(clientID, session);
        this.clientConsumeThreadMap.put(clientID, consumeTask);
    }

    public void stopConsume(String clientID) {
        ConsumeTask consumeTask = (ConsumeTask)this.clientConsumeThreadMap.get(clientID);
        if (consumeTask != null) {
            consumeTask.removeClientConsume(clientID);
            this.clientConsumeThreadMap.remove(clientID);
        }
        this.removeConsumer(clientID);
    }

    public void acknowledge(String clientID, int packageId) {
        MqttSession session = this.sessionManager.getSession(clientID);
        if (session != null) {
            BrokerMessage brokerMessage = session.getMessageAcknowledgedZone().acquireAcknowledgedMessage(packageId);
            if (brokerMessage != null) {
                short partition = brokerMessage.getPartition();
                long index = brokerMessage.getMsgIndexNo();
                String topic = brokerMessage.getTopic();
                Consumer consumer = this.getConsumer(clientID, topic);
                if (consumer != null) {
                    this.asyncAcknowledgeExecutorService.submit(() -> this.commitAcknowledge(consumer, partition, index));
                }
            }
        } else {
            LOG.warn("ClientId: {} has removed session.", (Object)clientID);
        }
    }

    private ConsumeTask selectThreadConsume(String clientID, MqttSession session) {
        int threadPos = this.selector.select(clientID, CONSUME_THREAD_TOTAL);
        ConsumeTask consumeTask = (ConsumeTask)this.consumeThreadMap.get(threadPos);
        consumeTask.addClientConsume(clientID, session);
        return consumeTask;
    }

    public Consumer getConsumer(String clientID, String topic) {
        Consumer consumer = null;
        if (this.connectionManager.isConnected(clientID)) {
            MqttConnection connection = this.connectionManager.getConnection(clientID);
            String application = connection.getApplication();
            String clientGroup = connection.getClientGroupName();
            String consumerId = connection.getConsumer(topic, application);
            if (Strings.isNullOrEmpty((String)consumerId) || (consumer = (Consumer)this.consumers.get(this.generateConsumerId(clientID, topic, application, clientGroup))) == null) {
                consumerId = this.generateConsumerId(clientID, topic, application, clientGroup);
                consumer = new Consumer();
                consumer.setId(consumerId);
                consumer.setConnectionId(connection.getId());
                consumer.setApp(application);
                consumer.setTopic(topic);
                consumer.setType(Consumer.ConsumeType.MQTT);
                Consumer oldConsumer = this.consumers.putIfAbsent(consumerId, consumer);
                connection.addConsumer(topic, application, consumerId);
                if (oldConsumer != null) {
                    consumer = oldConsumer;
                }
            }
        }
        return consumer;
    }

    public void removeConsumer(String clientID) {
        if (this.connectionManager.isConnected(clientID)) {
            MqttConnection connection = this.connectionManager.getConnection(clientID);
            for (String app : connection.getConsumers().keySet()) {
                ConcurrentMap topicIds = (ConcurrentMap)connection.getConsumers().get(app);
                for (String topic : topicIds.keySet()) {
                    String id = (String)topicIds.get(topic);
                    if (Strings.isNullOrEmpty((String)id)) continue;
                    this.consumers.remove(id);
                    topicIds.remove(topic, id);
                }
            }
        }
    }

    private String generateConsumerId(String clientID, String topic, String application, String clientGroup) {
        return String.format("%s_consumer_%s_%s_%s", clientID, application, topic, clientGroup);
    }

    private void commitAcknowledge(Consumer consumer, short partition, long index) {
        try {
            this.consume.setAckIndex(consumer, partition, index);
        }
        catch (JoyQueueException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private class ConsumeTask
    implements Runnable {
        private String name = "consume-";
        private boolean isRunning = true;
        private ConcurrentMap<String, MqttSession> clientConsumeMap = new ConcurrentHashMap<String, MqttSession>();

        ConsumeTask(String name) {
            this.name = this.name + name;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void setRunning(boolean running) {
            this.isRunning = running;
        }

        public void addClientConsume(String clientID, MqttSession session) {
            this.clientConsumeMap.put(clientID, session);
        }

        public void removeClientConsume(String clientID) {
            MqttSession session = (MqttSession)this.clientConsumeMap.remove(clientID);
        }

        @Override
        public void run() {
            while (this.isRunning) {
                try {
                    if (this.clientConsumeMap.size() > 0) {
                        this.clientConsumeMap.forEach((clientID, session) -> {
                            Set<MqttSubscription> subscriptions = session.listSubsciptions();
                            if (subscriptions != null && subscriptions.size() > 0) {
                                subscriptions.forEach(subscription -> {
                                    String topic = subscription.getTopicFilter().toString();
                                    int qos = subscription.getRequestedQos().value();
                                    Consumer consumer = MqttConsumerManager.this.getConsumer((String)clientID, topic);
                                    if (consumer != null) {
                                        try {
                                            MqttConsumerManager.this.asyncPublishExecutorService.execute(() -> {
                                                try {
                                                    MqttConsumerManager.this.messagePublisher.publish2Subscriber(this.name, (String)clientID, (MqttSession)session, consumer, qos);
                                                }
                                                catch (Exception e) {
                                                    LOG.error(e.getMessage(), (Throwable)e);
                                                }
                                            });
                                        }
                                        catch (Exception e) {
                                            LOG.error(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                });
                            }
                        });
                        try {
                            Thread.sleep(800L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn("mqtt consumer manager thread: <{}> interrupted, exception: {}", (Object)this.name, (Object)e.getMessage());
                        }
                        continue;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("mqtt consumer manager thread: <{}> interrupted, exception: {}", (Object)this.name, (Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOG.error("Thread: <{}>, mqtt consume client message consume error, topic: <{}>, cause: <{}>", (Object)this.name, (Object)e.getMessage());
                }
            }
            LOG.info("mqtt consumer manager thread: <{}> stop.", (Object)this.name);
        }
    }
}

